# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NetworkSecurityGroup(object):
    """
    A list of Network Security Group `OCIDs`__ associated with this Lustre file system. For more information about NSGs, see `Security Rules`__.

    __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
    __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NetworkSecurityGroup object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param nsg_ids:
            The value to assign to the nsg_ids property of this NetworkSecurityGroup.
        :type nsg_ids: list[str]

        """
        self.swagger_types = {
            'nsg_ids': 'list[str]'
        }
        self.attribute_map = {
            'nsg_ids': 'nsgIds'
        }
        self._nsg_ids = None

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this NetworkSecurityGroup.
        A list of Network Security Group `OCIDs`__ associated with this lustre file system.
        A maximum of 5 is allowed.
        Setting this to an empty array after the list is created removes the lustre file system from all NSGs.
        For more information about NSGs, see `Security Rules`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :return: The nsg_ids of this NetworkSecurityGroup.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this NetworkSecurityGroup.
        A list of Network Security Group `OCIDs`__ associated with this lustre file system.
        A maximum of 5 is allowed.
        Setting this to an empty array after the list is created removes the lustre file system from all NSGs.
        For more information about NSGs, see `Security Rules`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm
        __ https://docs.cloud.oracle.com/Content/Network/Concepts/securityrules.htm


        :param nsg_ids: The nsg_ids of this NetworkSecurityGroup.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
