# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CopyPolicy(object):
    """
    A policy of a DB system to schedule cross-region DB system backup copy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CopyPolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param copy_to_region:
            The value to assign to the copy_to_region property of this CopyPolicy.
        :type copy_to_region: str

        :param backup_copy_retention_in_days:
            The value to assign to the backup_copy_retention_in_days property of this CopyPolicy.
        :type backup_copy_retention_in_days: int

        """
        self.swagger_types = {
            'copy_to_region': 'str',
            'backup_copy_retention_in_days': 'int'
        }
        self.attribute_map = {
            'copy_to_region': 'copyToRegion',
            'backup_copy_retention_in_days': 'backupCopyRetentionInDays'
        }
        self._copy_to_region = None
        self._backup_copy_retention_in_days = None

    @property
    def copy_to_region(self):
        """
        **[Required]** Gets the copy_to_region of this CopyPolicy.
        The destination region name to which the DB system backup will be copied.


        :return: The copy_to_region of this CopyPolicy.
        :rtype: str
        """
        return self._copy_to_region

    @copy_to_region.setter
    def copy_to_region(self, copy_to_region):
        """
        Sets the copy_to_region of this CopyPolicy.
        The destination region name to which the DB system backup will be copied.


        :param copy_to_region: The copy_to_region of this CopyPolicy.
        :type: str
        """
        self._copy_to_region = copy_to_region

    @property
    def backup_copy_retention_in_days(self):
        """
        Gets the backup_copy_retention_in_days of this CopyPolicy.
        Number of days to retain the copied DB system backup.


        :return: The backup_copy_retention_in_days of this CopyPolicy.
        :rtype: int
        """
        return self._backup_copy_retention_in_days

    @backup_copy_retention_in_days.setter
    def backup_copy_retention_in_days(self, backup_copy_retention_in_days):
        """
        Sets the backup_copy_retention_in_days of this CopyPolicy.
        Number of days to retain the copied DB system backup.


        :param backup_copy_retention_in_days: The backup_copy_retention_in_days of this CopyPolicy.
        :type: int
        """
        self._backup_copy_retention_in_days = backup_copy_retention_in_days

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
