# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190415


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbSystemSnapshotSummary(object):
    """
    A summary of snapshot of the DB system details at the time of the backup.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DbSystemSnapshotSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this DbSystemSnapshotSummary.
        :type display_name: str

        :param id:
            The value to assign to the id property of this DbSystemSnapshotSummary.
        :type id: str

        :param region:
            The value to assign to the region property of this DbSystemSnapshotSummary.
        :type region: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'id': 'str',
            'region': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'id': 'id',
            'region': 'region'
        }
        self._display_name = None
        self._id = None
        self._region = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DbSystemSnapshotSummary.
        The user-friendly name for the DB system. It does not have to be unique.


        :return: The display_name of this DbSystemSnapshotSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DbSystemSnapshotSummary.
        The user-friendly name for the DB system. It does not have to be unique.


        :param display_name: The display_name of this DbSystemSnapshotSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbSystemSnapshotSummary.
        The OCID of the DB System.


        :return: The id of this DbSystemSnapshotSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbSystemSnapshotSummary.
        The OCID of the DB System.


        :param id: The id of this DbSystemSnapshotSummary.
        :type: str
        """
        self._id = id

    @property
    def region(self):
        """
        **[Required]** Gets the region of this DbSystemSnapshotSummary.
        The region identifier of the region where the DB system exists.
        For more information, please see `Regions and Availability Domains`__.

        __ https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :return: The region of this DbSystemSnapshotSummary.
        :rtype: str
        """
        return self._region

    @region.setter
    def region(self, region):
        """
        Sets the region of this DbSystemSnapshotSummary.
        The region identifier of the region where the DB system exists.
        For more information, please see `Regions and Availability Domains`__.

        __ https://docs.oracle.com/en-us/iaas/Content/General/Concepts/regions.htm


        :param region: The region of this DbSystemSnapshotSummary.
        :type: str
        """
        self._region = region

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
