# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateConfigurationDetails(object):
    """
    A tenancy or service-level configuration. The discriminator value
    `UpdateConfigurationDetails.environment` must match the service's
    environment type.
    """

    #: A constant which can be used with the environment property of a UpdateConfigurationDetails.
    #: This constant has a value of "MULTI_TENANCY"
    ENVIRONMENT_MULTI_TENANCY = "MULTI_TENANCY"

    #: A constant which can be used with the environment property of a UpdateConfigurationDetails.
    #: This constant has a value of "HOSTED"
    ENVIRONMENT_HOSTED = "HOSTED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateConfigurationDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.nosql.models.UpdateMultiTenancyConfigurationDetails`
        * :class:`~oci.nosql.models.UpdateHostedConfigurationDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param environment:
            The value to assign to the environment property of this UpdateConfigurationDetails.
            Allowed values for this property are: "MULTI_TENANCY", "HOSTED"
        :type environment: str

        """
        self.swagger_types = {
            'environment': 'str'
        }
        self.attribute_map = {
            'environment': 'environment'
        }
        self._environment = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['environment']

        if type == 'MULTI_TENANCY':
            return 'UpdateMultiTenancyConfigurationDetails'

        if type == 'HOSTED':
            return 'UpdateHostedConfigurationDetails'
        else:
            return 'UpdateConfigurationDetails'

    @property
    def environment(self):
        """
        **[Required]** Gets the environment of this UpdateConfigurationDetails.
        The service environment type.

        Allowed values for this property are: "MULTI_TENANCY", "HOSTED"


        :return: The environment of this UpdateConfigurationDetails.
        :rtype: str
        """
        return self._environment

    @environment.setter
    def environment(self, environment):
        """
        Sets the environment of this UpdateConfigurationDetails.
        The service environment type.


        :param environment: The environment of this UpdateConfigurationDetails.
        :type: str
        """
        allowed_values = ["MULTI_TENANCY", "HOSTED"]
        if not value_allowed_none_or_none_sentinel(environment, allowed_values):
            raise ValueError(
                f"Invalid value for `environment`, must be None or one of {allowed_values}"
            )
        self._environment = environment

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
