# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180828


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ConfigureOutboundClusterDetails(object):
    """
    Details for configuring the cluster to work as an Outbound cluster
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ConfigureOutboundClusterDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param inbound_cluster_ids:
            The value to assign to the inbound_cluster_ids property of this ConfigureOutboundClusterDetails.
        :type inbound_cluster_ids: list[str]

        """
        self.swagger_types = {
            'inbound_cluster_ids': 'list[str]'
        }
        self.attribute_map = {
            'inbound_cluster_ids': 'inboundClusterIds'
        }
        self._inbound_cluster_ids = None

    @property
    def inbound_cluster_ids(self):
        """
        **[Required]** Gets the inbound_cluster_ids of this ConfigureOutboundClusterDetails.
        List of inbound clusters that will be queried using cross cluster search


        :return: The inbound_cluster_ids of this ConfigureOutboundClusterDetails.
        :rtype: list[str]
        """
        return self._inbound_cluster_ids

    @inbound_cluster_ids.setter
    def inbound_cluster_ids(self, inbound_cluster_ids):
        """
        Sets the inbound_cluster_ids of this ConfigureOutboundClusterDetails.
        List of inbound clusters that will be queried using cross cluster search


        :param inbound_cluster_ids: The inbound_cluster_ids of this ConfigureOutboundClusterDetails.
        :type: list[str]
        """
        self._inbound_cluster_ids = inbound_cluster_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
