# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630

from .create_macs_managed_cloud_exadata_cluster_details import CreateMacsManagedCloudExadataClusterDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMacsManagedCloudExadataVmclusterDetails(CreateMacsManagedCloudExadataClusterDetails):
    """
    The information of the VM Cluster which contains databases.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMacsManagedCloudExadataVmclusterDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.opsi.models.CreateMacsManagedCloudExadataVmclusterDetails.vm_cluster_type` attribute
        of this class is ``vmCluster`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vm_cluster_type:
            The value to assign to the vm_cluster_type property of this CreateMacsManagedCloudExadataVmclusterDetails.
            Allowed values for this property are: "vmCluster", "autonomousVmCluster"
        :type vm_cluster_type: str

        :param vmcluster_id:
            The value to assign to the vmcluster_id property of this CreateMacsManagedCloudExadataVmclusterDetails.
        :type vmcluster_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateMacsManagedCloudExadataVmclusterDetails.
        :type compartment_id: str

        :param member_database_details:
            The value to assign to the member_database_details property of this CreateMacsManagedCloudExadataVmclusterDetails.
        :type member_database_details: list[oci.opsi.models.CreateMacsManagedCloudDatabaseInsightDetails]

        :param member_autonomous_details:
            The value to assign to the member_autonomous_details property of this CreateMacsManagedCloudExadataVmclusterDetails.
        :type member_autonomous_details: list[oci.opsi.models.CreateMacsManagedAutonomousDatabaseInsightDetails]

        """
        self.swagger_types = {
            'vm_cluster_type': 'str',
            'vmcluster_id': 'str',
            'compartment_id': 'str',
            'member_database_details': 'list[CreateMacsManagedCloudDatabaseInsightDetails]',
            'member_autonomous_details': 'list[CreateMacsManagedAutonomousDatabaseInsightDetails]'
        }
        self.attribute_map = {
            'vm_cluster_type': 'vmClusterType',
            'vmcluster_id': 'vmclusterId',
            'compartment_id': 'compartmentId',
            'member_database_details': 'memberDatabaseDetails',
            'member_autonomous_details': 'memberAutonomousDetails'
        }
        self._vm_cluster_type = None
        self._vmcluster_id = None
        self._compartment_id = None
        self._member_database_details = None
        self._member_autonomous_details = None
        self._vm_cluster_type = 'vmCluster'

    @property
    def member_database_details(self):
        """
        Gets the member_database_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        The databases that belong to the VM Cluster


        :return: The member_database_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        :rtype: list[oci.opsi.models.CreateMacsManagedCloudDatabaseInsightDetails]
        """
        return self._member_database_details

    @member_database_details.setter
    def member_database_details(self, member_database_details):
        """
        Sets the member_database_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        The databases that belong to the VM Cluster


        :param member_database_details: The member_database_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        :type: list[oci.opsi.models.CreateMacsManagedCloudDatabaseInsightDetails]
        """
        self._member_database_details = member_database_details

    @property
    def member_autonomous_details(self):
        """
        Gets the member_autonomous_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        The autonomous databases that belong to the Autonmous VM Cluster


        :return: The member_autonomous_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        :rtype: list[oci.opsi.models.CreateMacsManagedAutonomousDatabaseInsightDetails]
        """
        return self._member_autonomous_details

    @member_autonomous_details.setter
    def member_autonomous_details(self, member_autonomous_details):
        """
        Sets the member_autonomous_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        The autonomous databases that belong to the Autonmous VM Cluster


        :param member_autonomous_details: The member_autonomous_details of this CreateMacsManagedCloudExadataVmclusterDetails.
        :type: list[oci.opsi.models.CreateMacsManagedAutonomousDatabaseInsightDetails]
        """
        self._member_autonomous_details = member_autonomous_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
