# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceAnalyticsInstanceOacNetworkDetails(object):
    """
    Details required when provisioning OAC on a private network.

    Example: `{\"subnetId\":\"ocid...\", ...}`
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceAnalyticsInstanceOacNetworkDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param subnet_id:
            The value to assign to the subnet_id property of this ResourceAnalyticsInstanceOacNetworkDetails.
        :type subnet_id: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this ResourceAnalyticsInstanceOacNetworkDetails.
        :type nsg_ids: list[str]

        """
        self.swagger_types = {
            'subnet_id': 'str',
            'nsg_ids': 'list[str]'
        }
        self.attribute_map = {
            'subnet_id': 'subnetId',
            'nsg_ids': 'nsgIds'
        }
        self._subnet_id = None
        self._nsg_ids = None

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this ResourceAnalyticsInstanceOacNetworkDetails.
        The `OCID`__ of the subnet for the private network details.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this ResourceAnalyticsInstanceOacNetworkDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this ResourceAnalyticsInstanceOacNetworkDetails.
        The `OCID`__ of the subnet for the private network details.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this ResourceAnalyticsInstanceOacNetworkDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this ResourceAnalyticsInstanceOacNetworkDetails.
        List of Network Security Group `OCID`__'s for the private network details.

        Example: `[\"ocid...\", \"ocid...\"]`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The nsg_ids of this ResourceAnalyticsInstanceOacNetworkDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this ResourceAnalyticsInstanceOacNetworkDetails.
        List of Network Security Group `OCID`__'s for the private network details.

        Example: `[\"ocid...\", \"ocid...\"]`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param nsg_ids: The nsg_ids of this ResourceAnalyticsInstanceOacNetworkDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
