# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180608


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SourceRegionInformation(object):
    """
    Details for the source that the source secret has.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SourceRegionInformation object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_key_id:
            The value to assign to the source_key_id property of this SourceRegionInformation.
        :type source_key_id: str

        :param source_region:
            The value to assign to the source_region property of this SourceRegionInformation.
        :type source_region: str

        :param source_vault_id:
            The value to assign to the source_vault_id property of this SourceRegionInformation.
        :type source_vault_id: str

        """
        self.swagger_types = {
            'source_key_id': 'str',
            'source_region': 'str',
            'source_vault_id': 'str'
        }
        self.attribute_map = {
            'source_key_id': 'sourceKeyId',
            'source_region': 'sourceRegion',
            'source_vault_id': 'sourceVaultId'
        }
        self._source_key_id = None
        self._source_region = None
        self._source_vault_id = None

    @property
    def source_key_id(self):
        """
        **[Required]** Gets the source_key_id of this SourceRegionInformation.
        The OCID of the source region KMS key.


        :return: The source_key_id of this SourceRegionInformation.
        :rtype: str
        """
        return self._source_key_id

    @source_key_id.setter
    def source_key_id(self, source_key_id):
        """
        Sets the source_key_id of this SourceRegionInformation.
        The OCID of the source region KMS key.


        :param source_key_id: The source_key_id of this SourceRegionInformation.
        :type: str
        """
        self._source_key_id = source_key_id

    @property
    def source_region(self):
        """
        **[Required]** Gets the source_region of this SourceRegionInformation.
        The name of the source's region.


        :return: The source_region of this SourceRegionInformation.
        :rtype: str
        """
        return self._source_region

    @source_region.setter
    def source_region(self, source_region):
        """
        Sets the source_region of this SourceRegionInformation.
        The name of the source's region.


        :param source_region: The source_region of this SourceRegionInformation.
        :type: str
        """
        self._source_region = source_region

    @property
    def source_vault_id(self):
        """
        **[Required]** Gets the source_vault_id of this SourceRegionInformation.
        The OCID of the source region's Vault.


        :return: The source_vault_id of this SourceRegionInformation.
        :rtype: str
        """
        return self._source_vault_id

    @source_vault_id.setter
    def source_vault_id(self, source_vault_id):
        """
        Sets the source_vault_id of this SourceRegionInformation.
        The OCID of the source region's Vault.


        :param source_vault_id: The source_vault_id of this SourceRegionInformation.
        :type: str
        """
        self._source_vault_id = source_vault_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
