# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WlsDomainSummary(object):
    """
    The summary information about a Weblogic domain.
    """

    #: A constant which can be used with the patch_readiness_status property of a WlsDomainSummary.
    #: This constant has a value of "OK"
    PATCH_READINESS_STATUS_OK = "OK"

    #: A constant which can be used with the patch_readiness_status property of a WlsDomainSummary.
    #: This constant has a value of "WARNING"
    PATCH_READINESS_STATUS_WARNING = "WARNING"

    #: A constant which can be used with the patch_readiness_status property of a WlsDomainSummary.
    #: This constant has a value of "ERROR"
    PATCH_READINESS_STATUS_ERROR = "ERROR"

    #: A constant which can be used with the patch_readiness_status property of a WlsDomainSummary.
    #: This constant has a value of "UNKNOWN"
    PATCH_READINESS_STATUS_UNKNOWN = "UNKNOWN"

    def __init__(self, **kwargs):
        """
        Initializes a new WlsDomainSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this WlsDomainSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this WlsDomainSummary.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this WlsDomainSummary.
        :type compartment_id: str

        :param middleware_type:
            The value to assign to the middleware_type property of this WlsDomainSummary.
        :type middleware_type: str

        :param weblogic_version:
            The value to assign to the weblogic_version property of this WlsDomainSummary.
        :type weblogic_version: str

        :param patch_readiness_status:
            The value to assign to the patch_readiness_status property of this WlsDomainSummary.
            Allowed values for this property are: "OK", "WARNING", "ERROR", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type patch_readiness_status: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this WlsDomainSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this WlsDomainSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this WlsDomainSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this WlsDomainSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this WlsDomainSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this WlsDomainSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this WlsDomainSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'middleware_type': 'str',
            'weblogic_version': 'str',
            'patch_readiness_status': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'middleware_type': 'middlewareType',
            'weblogic_version': 'weblogicVersion',
            'patch_readiness_status': 'patchReadinessStatus',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._middleware_type = None
        self._weblogic_version = None
        self._patch_readiness_status = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this WlsDomainSummary.
        The `OCID`__ of the WebLogic domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this WlsDomainSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WlsDomainSummary.
        The `OCID`__ of the WebLogic domain.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this WlsDomainSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this WlsDomainSummary.
        A user-friendly name that does not have to be unique and is changeable.


        :return: The display_name of this WlsDomainSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this WlsDomainSummary.
        A user-friendly name that does not have to be unique and is changeable.


        :param display_name: The display_name of this WlsDomainSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this WlsDomainSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this WlsDomainSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this WlsDomainSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this WlsDomainSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def middleware_type(self):
        """
        Gets the middleware_type of this WlsDomainSummary.
        The middleware type on the administration server of the WebLogic domain.


        :return: The middleware_type of this WlsDomainSummary.
        :rtype: str
        """
        return self._middleware_type

    @middleware_type.setter
    def middleware_type(self, middleware_type):
        """
        Sets the middleware_type of this WlsDomainSummary.
        The middleware type on the administration server of the WebLogic domain.


        :param middleware_type: The middleware_type of this WlsDomainSummary.
        :type: str
        """
        self._middleware_type = middleware_type

    @property
    def weblogic_version(self):
        """
        Gets the weblogic_version of this WlsDomainSummary.
        The version of the WebLogic domain.


        :return: The weblogic_version of this WlsDomainSummary.
        :rtype: str
        """
        return self._weblogic_version

    @weblogic_version.setter
    def weblogic_version(self, weblogic_version):
        """
        Sets the weblogic_version of this WlsDomainSummary.
        The version of the WebLogic domain.


        :param weblogic_version: The weblogic_version of this WlsDomainSummary.
        :type: str
        """
        self._weblogic_version = weblogic_version

    @property
    def patch_readiness_status(self):
        """
        Gets the patch_readiness_status of this WlsDomainSummary.
        The patch readiness status of the WebLogic domain.

        Allowed values for this property are: "OK", "WARNING", "ERROR", "UNKNOWN", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The patch_readiness_status of this WlsDomainSummary.
        :rtype: str
        """
        return self._patch_readiness_status

    @patch_readiness_status.setter
    def patch_readiness_status(self, patch_readiness_status):
        """
        Sets the patch_readiness_status of this WlsDomainSummary.
        The patch readiness status of the WebLogic domain.


        :param patch_readiness_status: The patch_readiness_status of this WlsDomainSummary.
        :type: str
        """
        allowed_values = ["OK", "WARNING", "ERROR", "UNKNOWN"]
        if not value_allowed_none_or_none_sentinel(patch_readiness_status, allowed_values):
            patch_readiness_status = 'UNKNOWN_ENUM_VALUE'
        self._patch_readiness_status = patch_readiness_status

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this WlsDomainSummary.
        The current state of the WebLogic domain.


        :return: The lifecycle_state of this WlsDomainSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this WlsDomainSummary.
        The current state of the WebLogic domain.


        :param lifecycle_state: The lifecycle_state of this WlsDomainSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this WlsDomainSummary.
        A message that describes the current state of the WebLogic domain in more detail. For example,
        can be used to provide actionable information for a resource in the 'Failed' state.


        :return: The lifecycle_details of this WlsDomainSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this WlsDomainSummary.
        A message that describes the current state of the WebLogic domain in more detail. For example,
        can be used to provide actionable information for a resource in the 'Failed' state.


        :param lifecycle_details: The lifecycle_details of this WlsDomainSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        Gets the time_created of this WlsDomainSummary.
        The date and time the WebLogic domain was created (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this WlsDomainSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this WlsDomainSummary.
        The date and time the WebLogic domain was created (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this WlsDomainSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this WlsDomainSummary.
        The date and time the WebLogic domain was updated (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this WlsDomainSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this WlsDomainSummary.
        The date and time the WebLogic domain was updated (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this WlsDomainSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this WlsDomainSummary.
        Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this WlsDomainSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this WlsDomainSummary.
        Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this WlsDomainSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this WlsDomainSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this WlsDomainSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this WlsDomainSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this WlsDomainSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this WlsDomainSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this WlsDomainSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this WlsDomainSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this WlsDomainSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
