# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StreamJobSummary(object):
    """
    Job details for a stream analysis.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StreamJobSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this StreamJobSummary.
        :type id: str

        :param stream_source_id:
            The value to assign to the stream_source_id property of this StreamJobSummary.
        :type stream_source_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this StreamJobSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this StreamJobSummary.
        :type display_name: str

        :param features:
            The value to assign to the features property of this StreamJobSummary.
        :type features: list[oci.ai_vision.models.VideoStreamFeature]

        :param stream_output_location:
            The value to assign to the stream_output_location property of this StreamJobSummary.
        :type stream_output_location: oci.ai_vision.models.StreamOutputLocation

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this StreamJobSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this StreamJobSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this StreamJobSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this StreamJobSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this StreamJobSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this StreamJobSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this StreamJobSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'stream_source_id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'features': 'list[VideoStreamFeature]',
            'stream_output_location': 'StreamOutputLocation',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'stream_source_id': 'streamSourceId',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'features': 'features',
            'stream_output_location': 'streamOutputLocation',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._stream_source_id = None
        self._compartment_id = None
        self._display_name = None
        self._features = None
        self._stream_output_location = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this StreamJobSummary.
        `OCID`__ of the streamJob.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this StreamJobSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this StreamJobSummary.
        `OCID`__ of the streamJob.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this StreamJobSummary.
        :type: str
        """
        self._id = id

    @property
    def stream_source_id(self):
        """
        **[Required]** Gets the stream_source_id of this StreamJobSummary.
        `OCID`__ of the streamSource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The stream_source_id of this StreamJobSummary.
        :rtype: str
        """
        return self._stream_source_id

    @stream_source_id.setter
    def stream_source_id(self, stream_source_id):
        """
        Sets the stream_source_id of this StreamJobSummary.
        `OCID`__ of the streamSource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param stream_source_id: The stream_source_id of this StreamJobSummary.
        :type: str
        """
        self._stream_source_id = stream_source_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this StreamJobSummary.
        `OCID`__ of compartment

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this StreamJobSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this StreamJobSummary.
        `OCID`__ of compartment

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this StreamJobSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        Gets the display_name of this StreamJobSummary.
        Stream job display name.


        :return: The display_name of this StreamJobSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this StreamJobSummary.
        Stream job display name.


        :param display_name: The display_name of this StreamJobSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def features(self):
        """
        **[Required]** Gets the features of this StreamJobSummary.
        List of document analysis features.


        :return: The features of this StreamJobSummary.
        :rtype: list[oci.ai_vision.models.VideoStreamFeature]
        """
        return self._features

    @features.setter
    def features(self, features):
        """
        Sets the features of this StreamJobSummary.
        List of document analysis features.


        :param features: The features of this StreamJobSummary.
        :type: list[oci.ai_vision.models.VideoStreamFeature]
        """
        self._features = features

    @property
    def stream_output_location(self):
        """
        Gets the stream_output_location of this StreamJobSummary.

        :return: The stream_output_location of this StreamJobSummary.
        :rtype: oci.ai_vision.models.StreamOutputLocation
        """
        return self._stream_output_location

    @stream_output_location.setter
    def stream_output_location(self, stream_output_location):
        """
        Sets the stream_output_location of this StreamJobSummary.

        :param stream_output_location: The stream_output_location of this StreamJobSummary.
        :type: oci.ai_vision.models.StreamOutputLocation
        """
        self._stream_output_location = stream_output_location

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this StreamJobSummary.
        The current state of the Stream job.


        :return: The lifecycle_state of this StreamJobSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this StreamJobSummary.
        The current state of the Stream job.


        :param lifecycle_state: The lifecycle_state of this StreamJobSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        **[Required]** Gets the lifecycle_details of this StreamJobSummary.
        Additional Details of the state of streamJob


        :return: The lifecycle_details of this StreamJobSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this StreamJobSummary.
        Additional Details of the state of streamJob


        :param lifecycle_details: The lifecycle_details of this StreamJobSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this StreamJobSummary.
        When the streamJob was created, as an RFC3339 datetime string.


        :return: The time_created of this StreamJobSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this StreamJobSummary.
        When the streamJob was created, as an RFC3339 datetime string.


        :param time_created: The time_created of this StreamJobSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this StreamJobSummary.
        When the streamJob was updated, as an RFC3339 datetime string.


        :return: The time_updated of this StreamJobSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this StreamJobSummary.
        When the streamJob was updated, as an RFC3339 datetime string.


        :param time_updated: The time_updated of this StreamJobSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this StreamJobSummary.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this StreamJobSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this StreamJobSummary.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this StreamJobSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this StreamJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this StreamJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this StreamJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this StreamJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this StreamJobSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        For example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this StreamJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this StreamJobSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        For example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this StreamJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
