# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCccUpgradeScheduleDetails(object):
    """
    Defines a schedule for times when automated Compute Cloud@Customer upgrades are preferred.
    A created upgrade schedule must supply events with a minimum frequency and duration or
    the schedule will be rejected. Upgrades may impact performance of
    Compute Cloud@Customer infrastructures when they are being applied.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCccUpgradeScheduleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateCccUpgradeScheduleDetails.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateCccUpgradeScheduleDetails.
        :type compartment_id: str

        :param description:
            The value to assign to the description property of this CreateCccUpgradeScheduleDetails.
        :type description: str

        :param events:
            The value to assign to the events property of this CreateCccUpgradeScheduleDetails.
        :type events: list[oci.compute_cloud_at_customer.models.CreateCccScheduleEvent]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCccUpgradeScheduleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCccUpgradeScheduleDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'compartment_id': 'str',
            'description': 'str',
            'events': 'list[CreateCccScheduleEvent]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'description': 'description',
            'events': 'events',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._compartment_id = None
        self._description = None
        self._events = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateCccUpgradeScheduleDetails.
        Compute Cloud@Customer upgrade schedule display name.
        Avoid entering confidential information.


        :return: The display_name of this CreateCccUpgradeScheduleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCccUpgradeScheduleDetails.
        Compute Cloud@Customer upgrade schedule display name.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateCccUpgradeScheduleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateCccUpgradeScheduleDetails.
        Compartment `OCID`__ for the
        Compute Cloud@Customer Upgrade Schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateCccUpgradeScheduleDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateCccUpgradeScheduleDetails.
        Compartment `OCID`__ for the
        Compute Cloud@Customer Upgrade Schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateCccUpgradeScheduleDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def description(self):
        """
        Gets the description of this CreateCccUpgradeScheduleDetails.
        An optional description of the Compute Cloud@Customer upgrade schedule.
        Avoid entering confidential information.


        :return: The description of this CreateCccUpgradeScheduleDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateCccUpgradeScheduleDetails.
        An optional description of the Compute Cloud@Customer upgrade schedule.
        Avoid entering confidential information.


        :param description: The description of this CreateCccUpgradeScheduleDetails.
        :type: str
        """
        self._description = description

    @property
    def events(self):
        """
        **[Required]** Gets the events of this CreateCccUpgradeScheduleDetails.
        List of preferred times for Compute Cloud@Customer infrastructure to be upgraded.


        :return: The events of this CreateCccUpgradeScheduleDetails.
        :rtype: list[oci.compute_cloud_at_customer.models.CreateCccScheduleEvent]
        """
        return self._events

    @events.setter
    def events(self, events):
        """
        Sets the events of this CreateCccUpgradeScheduleDetails.
        List of preferred times for Compute Cloud@Customer infrastructure to be upgraded.


        :param events: The events of this CreateCccUpgradeScheduleDetails.
        :type: list[oci.compute_cloud_at_customer.models.CreateCccScheduleEvent]
        """
        self._events = events

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCccUpgradeScheduleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateCccUpgradeScheduleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCccUpgradeScheduleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateCccUpgradeScheduleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCccUpgradeScheduleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateCccUpgradeScheduleDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCccUpgradeScheduleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateCccUpgradeScheduleDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
