# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DisableDatabaseManagementFeatureDetails(object):
    """
    The details required to disable Database Management features for an Oracle cloud database.
    """

    #: A constant which can be used with the feature property of a DisableDatabaseManagementFeatureDetails.
    #: This constant has a value of "DIAGNOSTICS_AND_MANAGEMENT"
    FEATURE_DIAGNOSTICS_AND_MANAGEMENT = "DIAGNOSTICS_AND_MANAGEMENT"

    #: A constant which can be used with the feature property of a DisableDatabaseManagementFeatureDetails.
    #: This constant has a value of "DB_LIFECYCLE_MANAGEMENT"
    FEATURE_DB_LIFECYCLE_MANAGEMENT = "DB_LIFECYCLE_MANAGEMENT"

    #: A constant which can be used with the feature property of a DisableDatabaseManagementFeatureDetails.
    #: This constant has a value of "SQLWATCH"
    FEATURE_SQLWATCH = "SQLWATCH"

    def __init__(self, **kwargs):
        """
        Initializes a new DisableDatabaseManagementFeatureDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param feature:
            The value to assign to the feature property of this DisableDatabaseManagementFeatureDetails.
            Allowed values for this property are: "DIAGNOSTICS_AND_MANAGEMENT", "DB_LIFECYCLE_MANAGEMENT", "SQLWATCH"
        :type feature: str

        :param can_disable_all_pdbs:
            The value to assign to the can_disable_all_pdbs property of this DisableDatabaseManagementFeatureDetails.
        :type can_disable_all_pdbs: bool

        """
        self.swagger_types = {
            'feature': 'str',
            'can_disable_all_pdbs': 'bool'
        }
        self.attribute_map = {
            'feature': 'feature',
            'can_disable_all_pdbs': 'canDisableAllPdbs'
        }
        self._feature = None
        self._can_disable_all_pdbs = None

    @property
    def feature(self):
        """
        **[Required]** Gets the feature of this DisableDatabaseManagementFeatureDetails.
        The name of the Database Management feature.

        Allowed values for this property are: "DIAGNOSTICS_AND_MANAGEMENT", "DB_LIFECYCLE_MANAGEMENT", "SQLWATCH"


        :return: The feature of this DisableDatabaseManagementFeatureDetails.
        :rtype: str
        """
        return self._feature

    @feature.setter
    def feature(self, feature):
        """
        Sets the feature of this DisableDatabaseManagementFeatureDetails.
        The name of the Database Management feature.


        :param feature: The feature of this DisableDatabaseManagementFeatureDetails.
        :type: str
        """
        allowed_values = ["DIAGNOSTICS_AND_MANAGEMENT", "DB_LIFECYCLE_MANAGEMENT", "SQLWATCH"]
        if not value_allowed_none_or_none_sentinel(feature, allowed_values):
            raise ValueError(
                f"Invalid value for `feature`, must be None or one of {allowed_values}"
            )
        self._feature = feature

    @property
    def can_disable_all_pdbs(self):
        """
        Gets the can_disable_all_pdbs of this DisableDatabaseManagementFeatureDetails.
        Indicates whether Diagnostics & Management should be disabled for the pluggable databases before disabling it for the container database.


        :return: The can_disable_all_pdbs of this DisableDatabaseManagementFeatureDetails.
        :rtype: bool
        """
        return self._can_disable_all_pdbs

    @can_disable_all_pdbs.setter
    def can_disable_all_pdbs(self, can_disable_all_pdbs):
        """
        Sets the can_disable_all_pdbs of this DisableDatabaseManagementFeatureDetails.
        Indicates whether Diagnostics & Management should be disabled for the pluggable databases before disabling it for the container database.


        :param can_disable_all_pdbs: The can_disable_all_pdbs of this DisableDatabaseManagementFeatureDetails.
        :type: bool
        """
        self._can_disable_all_pdbs = can_disable_all_pdbs

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
