# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201005

from .validate_database_tools_connection_result import ValidateDatabaseToolsConnectionResult
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidateDatabaseToolsConnectionOracleDatabaseResult(ValidateDatabaseToolsConnectionResult):
    """
    Connection validaton result for the Oracle Database.
    """

    #: A constant which can be used with the dbms_cloud_status property of a ValidateDatabaseToolsConnectionOracleDatabaseResult.
    #: This constant has a value of "AVAILABLE"
    DBMS_CLOUD_STATUS_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the dbms_cloud_status property of a ValidateDatabaseToolsConnectionOracleDatabaseResult.
    #: This constant has a value of "UNAVAILABLE"
    DBMS_CLOUD_STATUS_UNAVAILABLE = "UNAVAILABLE"

    def __init__(self, **kwargs):
        """
        Initializes a new ValidateDatabaseToolsConnectionOracleDatabaseResult object with values from keyword arguments. The default value of the :py:attr:`~oci.database_tools.models.ValidateDatabaseToolsConnectionOracleDatabaseResult.type` attribute
        of this class is ``ORACLE_DATABASE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
            Allowed values for this property are: "ORACLE_DATABASE", "MYSQL", "POSTGRESQL", "GENERIC_JDBC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param code:
            The value to assign to the code property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type code: str

        :param message:
            The value to assign to the message property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type message: str

        :param cause:
            The value to assign to the cause property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type cause: str

        :param action:
            The value to assign to the action property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type action: str

        :param database_name:
            The value to assign to the database_name property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type database_name: str

        :param database_version:
            The value to assign to the database_version property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type database_version: str

        :param dbms_cloud_status:
            The value to assign to the dbms_cloud_status property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
            Allowed values for this property are: "AVAILABLE", "UNAVAILABLE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type dbms_cloud_status: str

        :param cloud_service:
            The value to assign to the cloud_service property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type cloud_service: str

        :param database_tools_identity_statuses:
            The value to assign to the database_tools_identity_statuses property of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type database_tools_identity_statuses: list[oci.database_tools.models.ValidationIdentityStatus]

        """
        self.swagger_types = {
            'type': 'str',
            'code': 'str',
            'message': 'str',
            'cause': 'str',
            'action': 'str',
            'database_name': 'str',
            'database_version': 'str',
            'dbms_cloud_status': 'str',
            'cloud_service': 'str',
            'database_tools_identity_statuses': 'list[ValidationIdentityStatus]'
        }
        self.attribute_map = {
            'type': 'type',
            'code': 'code',
            'message': 'message',
            'cause': 'cause',
            'action': 'action',
            'database_name': 'databaseName',
            'database_version': 'databaseVersion',
            'dbms_cloud_status': 'dbmsCloudStatus',
            'cloud_service': 'cloudService',
            'database_tools_identity_statuses': 'databaseToolsIdentityStatuses'
        }
        self._type = None
        self._code = None
        self._message = None
        self._cause = None
        self._action = None
        self._database_name = None
        self._database_version = None
        self._dbms_cloud_status = None
        self._cloud_service = None
        self._database_tools_identity_statuses = None
        self._type = 'ORACLE_DATABASE'

    @property
    def database_name(self):
        """
        Gets the database_name of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        The database name.


        :return: The database_name of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """
        Sets the database_name of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        The database name.


        :param database_name: The database_name of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type: str
        """
        self._database_name = database_name

    @property
    def database_version(self):
        """
        **[Required]** Gets the database_version of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        The database version.


        :return: The database_version of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :rtype: str
        """
        return self._database_version

    @database_version.setter
    def database_version(self, database_version):
        """
        Sets the database_version of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        The database version.


        :param database_version: The database_version of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type: str
        """
        self._database_version = database_version

    @property
    def dbms_cloud_status(self):
        """
        **[Required]** Gets the dbms_cloud_status of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        The DBMS_CLOUD package installation status.

        Allowed values for this property are: "AVAILABLE", "UNAVAILABLE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The dbms_cloud_status of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :rtype: str
        """
        return self._dbms_cloud_status

    @dbms_cloud_status.setter
    def dbms_cloud_status(self, dbms_cloud_status):
        """
        Sets the dbms_cloud_status of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        The DBMS_CLOUD package installation status.


        :param dbms_cloud_status: The dbms_cloud_status of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type: str
        """
        allowed_values = ["AVAILABLE", "UNAVAILABLE"]
        if not value_allowed_none_or_none_sentinel(dbms_cloud_status, allowed_values):
            dbms_cloud_status = 'UNKNOWN_ENUM_VALUE'
        self._dbms_cloud_status = dbms_cloud_status

    @property
    def cloud_service(self):
        """
        Gets the cloud_service of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        Displays the CLOUD_SERVICE value within the USERENV context


        :return: The cloud_service of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :rtype: str
        """
        return self._cloud_service

    @cloud_service.setter
    def cloud_service(self, cloud_service):
        """
        Sets the cloud_service of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        Displays the CLOUD_SERVICE value within the USERENV context


        :param cloud_service: The cloud_service of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type: str
        """
        self._cloud_service = cloud_service

    @property
    def database_tools_identity_statuses(self):
        """
        Gets the database_tools_identity_statuses of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        Status on whether a Database Tools identity type can be used with this connection or not.


        :return: The database_tools_identity_statuses of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :rtype: list[oci.database_tools.models.ValidationIdentityStatus]
        """
        return self._database_tools_identity_statuses

    @database_tools_identity_statuses.setter
    def database_tools_identity_statuses(self, database_tools_identity_statuses):
        """
        Sets the database_tools_identity_statuses of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        Status on whether a Database Tools identity type can be used with this connection or not.


        :param database_tools_identity_statuses: The database_tools_identity_statuses of this ValidateDatabaseToolsConnectionOracleDatabaseResult.
        :type: list[oci.database_tools.models.ValidationIdentityStatus]
        """
        self._database_tools_identity_statuses = database_tools_identity_statuses

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
