# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateImportedModelDetails(object):
    """
    The data to import a model.
    """

    #: A constant which can be used with the capabilities property of a CreateImportedModelDetails.
    #: This constant has a value of "TEXT_TO_TEXT"
    CAPABILITIES_TEXT_TO_TEXT = "TEXT_TO_TEXT"

    #: A constant which can be used with the capabilities property of a CreateImportedModelDetails.
    #: This constant has a value of "IMAGE_TEXT_TO_TEXT"
    CAPABILITIES_IMAGE_TEXT_TO_TEXT = "IMAGE_TEXT_TO_TEXT"

    #: A constant which can be used with the capabilities property of a CreateImportedModelDetails.
    #: This constant has a value of "EMBEDDING"
    CAPABILITIES_EMBEDDING = "EMBEDDING"

    #: A constant which can be used with the capabilities property of a CreateImportedModelDetails.
    #: This constant has a value of "RERANK"
    CAPABILITIES_RERANK = "RERANK"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateImportedModelDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateImportedModelDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateImportedModelDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateImportedModelDetails.
        :type compartment_id: str

        :param vendor:
            The value to assign to the vendor property of this CreateImportedModelDetails.
        :type vendor: str

        :param version:
            The value to assign to the version property of this CreateImportedModelDetails.
        :type version: str

        :param data_source:
            The value to assign to the data_source property of this CreateImportedModelDetails.
        :type data_source: oci.generative_ai.models.ModelDataSource

        :param capabilities:
            The value to assign to the capabilities property of this CreateImportedModelDetails.
            Allowed values for items in this list are: "TEXT_TO_TEXT", "IMAGE_TEXT_TO_TEXT", "EMBEDDING", "RERANK"
        :type capabilities: list[str]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateImportedModelDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateImportedModelDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'vendor': 'str',
            'version': 'str',
            'data_source': 'ModelDataSource',
            'capabilities': 'list[str]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'vendor': 'vendor',
            'version': 'version',
            'data_source': 'dataSource',
            'capabilities': 'capabilities',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._vendor = None
        self._version = None
        self._data_source = None
        self._capabilities = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateImportedModelDetails.
        A user-friendly name for the imported model.


        :return: The display_name of this CreateImportedModelDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateImportedModelDetails.
        A user-friendly name for the imported model.


        :param display_name: The display_name of this CreateImportedModelDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateImportedModelDetails.
        An optional description of the imported model.


        :return: The description of this CreateImportedModelDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateImportedModelDetails.
        An optional description of the imported model.


        :param description: The description of this CreateImportedModelDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateImportedModelDetails.
        The compartment OCID from which the model is imported.


        :return: The compartment_id of this CreateImportedModelDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateImportedModelDetails.
        The compartment OCID from which the model is imported.


        :param compartment_id: The compartment_id of this CreateImportedModelDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def vendor(self):
        """
        Gets the vendor of this CreateImportedModelDetails.
        The provider of the imported model.


        :return: The vendor of this CreateImportedModelDetails.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this CreateImportedModelDetails.
        The provider of the imported model.


        :param vendor: The vendor of this CreateImportedModelDetails.
        :type: str
        """
        self._vendor = vendor

    @property
    def version(self):
        """
        Gets the version of this CreateImportedModelDetails.
        The version of the imported model.


        :return: The version of this CreateImportedModelDetails.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this CreateImportedModelDetails.
        The version of the imported model.


        :param version: The version of this CreateImportedModelDetails.
        :type: str
        """
        self._version = version

    @property
    def data_source(self):
        """
        **[Required]** Gets the data_source of this CreateImportedModelDetails.

        :return: The data_source of this CreateImportedModelDetails.
        :rtype: oci.generative_ai.models.ModelDataSource
        """
        return self._data_source

    @data_source.setter
    def data_source(self, data_source):
        """
        Sets the data_source of this CreateImportedModelDetails.

        :param data_source: The data_source of this CreateImportedModelDetails.
        :type: oci.generative_ai.models.ModelDataSource
        """
        self._data_source = data_source

    @property
    def capabilities(self):
        """
        Gets the capabilities of this CreateImportedModelDetails.
        Specifies the intended use or supported capabilities of the imported model.

        Allowed values for items in this list are: "TEXT_TO_TEXT", "IMAGE_TEXT_TO_TEXT", "EMBEDDING", "RERANK"


        :return: The capabilities of this CreateImportedModelDetails.
        :rtype: list[str]
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """
        Sets the capabilities of this CreateImportedModelDetails.
        Specifies the intended use or supported capabilities of the imported model.


        :param capabilities: The capabilities of this CreateImportedModelDetails.
        :type: list[str]
        """
        allowed_values = ["TEXT_TO_TEXT", "IMAGE_TEXT_TO_TEXT", "EMBEDDING", "RERANK"]

        if capabilities and capabilities is not NONE_SENTINEL:
            for value in capabilities:
                if not value_allowed_none_or_none_sentinel(value, allowed_values):
                    raise ValueError(
                        f"Invalid value for `capabilities`, must be None or one of {allowed_values}"
                    )
        self._capabilities = capabilities

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateImportedModelDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateImportedModelDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateImportedModelDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateImportedModelDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateImportedModelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateImportedModelDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateImportedModelDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateImportedModelDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
