# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PropertyDefinition(object):
    """
    Defines an property of a macro, variable or query.
    """

    #: A constant which can be used with the type property of a PropertyDefinition.
    #: This constant has a value of "STRING"
    TYPE_STRING = "STRING"

    #: A constant which can be used with the type property of a PropertyDefinition.
    #: This constant has a value of "DOUBLE"
    TYPE_DOUBLE = "DOUBLE"

    #: A constant which can be used with the type property of a PropertyDefinition.
    #: This constant has a value of "FLOAT"
    TYPE_FLOAT = "FLOAT"

    #: A constant which can be used with the type property of a PropertyDefinition.
    #: This constant has a value of "LONG"
    TYPE_LONG = "LONG"

    #: A constant which can be used with the type property of a PropertyDefinition.
    #: This constant has a value of "INTEGER"
    TYPE_INTEGER = "INTEGER"

    #: A constant which can be used with the type property of a PropertyDefinition.
    #: This constant has a value of "TIMESTAMP"
    TYPE_TIMESTAMP = "TIMESTAMP"

    def __init__(self, **kwargs):
        """
        Initializes a new PropertyDefinition object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this PropertyDefinition.
        :type name: str

        :param value:
            The value to assign to the value property of this PropertyDefinition.
        :type value: str

        :param type:
            The value to assign to the type property of this PropertyDefinition.
            Allowed values for this property are: "STRING", "DOUBLE", "FLOAT", "LONG", "INTEGER", "TIMESTAMP", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param is_global:
            The value to assign to the is_global property of this PropertyDefinition.
        :type is_global: bool

        """
        self.swagger_types = {
            'name': 'str',
            'value': 'str',
            'type': 'str',
            'is_global': 'bool'
        }
        self.attribute_map = {
            'name': 'name',
            'value': 'value',
            'type': 'type',
            'is_global': 'isGlobal'
        }
        self._name = None
        self._value = None
        self._type = None
        self._is_global = None

    @property
    def name(self):
        """
        Gets the name of this PropertyDefinition.
        Name of the property.


        :return: The name of this PropertyDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PropertyDefinition.
        Name of the property.


        :param name: The name of this PropertyDefinition.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        Gets the value of this PropertyDefinition.
        Value of the property.


        :return: The value of this PropertyDefinition.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this PropertyDefinition.
        Value of the property.


        :param value: The value of this PropertyDefinition.
        :type: str
        """
        self._value = value

    @property
    def type(self):
        """
        Gets the type of this PropertyDefinition.
        Type of the property.

        Allowed values for this property are: "STRING", "DOUBLE", "FLOAT", "LONG", "INTEGER", "TIMESTAMP", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this PropertyDefinition.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this PropertyDefinition.
        Type of the property.


        :param type: The type of this PropertyDefinition.
        :type: str
        """
        allowed_values = ["STRING", "DOUBLE", "FLOAT", "LONG", "INTEGER", "TIMESTAMP"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def is_global(self):
        """
        Gets the is_global of this PropertyDefinition.
        True if property is for all macros.  Not applicable for macro variables or query.


        :return: The is_global of this PropertyDefinition.
        :rtype: bool
        """
        return self._is_global

    @is_global.setter
    def is_global(self, is_global):
        """
        Sets the is_global of this PropertyDefinition.
        True if property is for all macros.  Not applicable for macro variables or query.


        :param is_global: The is_global of this PropertyDefinition.
        :type: bool
        """
        self._is_global = is_global

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
