# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190828

from .configuration import Configuration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostedConfiguration(Configuration):
    """
    The service-level configuration for a hosted environment.
    Includes `kmsKey` for retrieving the service's
    encryption key state.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HostedConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.nosql.models.HostedConfiguration.environment` attribute
        of this class is ``HOSTED`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param environment:
            The value to assign to the environment property of this HostedConfiguration.
            Allowed values for this property are: "MULTI_TENANCY", "HOSTED"
        :type environment: str

        :param kms_key:
            The value to assign to the kms_key property of this HostedConfiguration.
        :type kms_key: oci.nosql.models.KmsKey

        """
        self.swagger_types = {
            'environment': 'str',
            'kms_key': 'KmsKey'
        }
        self.attribute_map = {
            'environment': 'environment',
            'kms_key': 'kmsKey'
        }
        self._environment = None
        self._kms_key = None
        self._environment = 'HOSTED'

    @property
    def kms_key(self):
        """
        **[Required]** Gets the kms_key of this HostedConfiguration.

        :return: The kms_key of this HostedConfiguration.
        :rtype: oci.nosql.models.KmsKey
        """
        return self._kms_key

    @kms_key.setter
    def kms_key(self, kms_key):
        """
        Sets the kms_key of this HostedConfiguration.

        :param kms_key: The kms_key of this HostedConfiguration.
        :type: oci.nosql.models.KmsKey
        """
        self._kms_key = kms_key

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
