# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230701


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatastoreClusterSummary(object):
    """
    An `Oracle Cloud VMware Solution`__ Datastore Cluster for software-defined data center.

    The Datastore Cluster combines multiple datastores into a single datastore cluster.

    __ https://docs.cloud.oracle.com/iaas/Content/VMware/Concepts/ocvsoverview.htm
    """

    #: A constant which can be used with the datastore_cluster_type property of a DatastoreClusterSummary.
    #: This constant has a value of "MANAGEMENT"
    DATASTORE_CLUSTER_TYPE_MANAGEMENT = "MANAGEMENT"

    #: A constant which can be used with the datastore_cluster_type property of a DatastoreClusterSummary.
    #: This constant has a value of "WORKLOAD"
    DATASTORE_CLUSTER_TYPE_WORKLOAD = "WORKLOAD"

    #: A constant which can be used with the lifecycle_state property of a DatastoreClusterSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DatastoreClusterSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DatastoreClusterSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DatastoreClusterSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DatastoreClusterSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DatastoreClusterSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new DatastoreClusterSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DatastoreClusterSummary.
        :type id: str

        :param datastore_ids:
            The value to assign to the datastore_ids property of this DatastoreClusterSummary.
        :type datastore_ids: list[str]

        :param compartment_id:
            The value to assign to the compartment_id property of this DatastoreClusterSummary.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this DatastoreClusterSummary.
        :type display_name: str

        :param cluster_id:
            The value to assign to the cluster_id property of this DatastoreClusterSummary.
        :type cluster_id: str

        :param sddc_id:
            The value to assign to the sddc_id property of this DatastoreClusterSummary.
        :type sddc_id: str

        :param esxi_host_ids:
            The value to assign to the esxi_host_ids property of this DatastoreClusterSummary.
        :type esxi_host_ids: list[str]

        :param datastore_cluster_type:
            The value to assign to the datastore_cluster_type property of this DatastoreClusterSummary.
            Allowed values for this property are: "MANAGEMENT", "WORKLOAD", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type datastore_cluster_type: str

        :param time_created:
            The value to assign to the time_created property of this DatastoreClusterSummary.
        :type time_created: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DatastoreClusterSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param availability_domain:
            The value to assign to the availability_domain property of this DatastoreClusterSummary.
        :type availability_domain: str

        :param capacity_in_gbs:
            The value to assign to the capacity_in_gbs property of this DatastoreClusterSummary.
        :type capacity_in_gbs: float

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DatastoreClusterSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DatastoreClusterSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DatastoreClusterSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'datastore_ids': 'list[str]',
            'compartment_id': 'str',
            'display_name': 'str',
            'cluster_id': 'str',
            'sddc_id': 'str',
            'esxi_host_ids': 'list[str]',
            'datastore_cluster_type': 'str',
            'time_created': 'datetime',
            'lifecycle_state': 'str',
            'availability_domain': 'str',
            'capacity_in_gbs': 'float',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'datastore_ids': 'datastoreIds',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'cluster_id': 'clusterId',
            'sddc_id': 'sddcId',
            'esxi_host_ids': 'esxiHostIds',
            'datastore_cluster_type': 'datastoreClusterType',
            'time_created': 'timeCreated',
            'lifecycle_state': 'lifecycleState',
            'availability_domain': 'availabilityDomain',
            'capacity_in_gbs': 'capacityInGBs',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._datastore_ids = None
        self._compartment_id = None
        self._display_name = None
        self._cluster_id = None
        self._sddc_id = None
        self._esxi_host_ids = None
        self._datastore_cluster_type = None
        self._time_created = None
        self._lifecycle_state = None
        self._availability_domain = None
        self._capacity_in_gbs = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DatastoreClusterSummary.
        The `OCID`__ of the Datastore.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DatastoreClusterSummary.
        The `OCID`__ of the Datastore.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this DatastoreClusterSummary.
        :type: str
        """
        self._id = id

    @property
    def datastore_ids(self):
        """
        **[Required]** Gets the datastore_ids of this DatastoreClusterSummary.
        The `OCIDs`__ of the Datastores that belong to the Datastore Cluster

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The datastore_ids of this DatastoreClusterSummary.
        :rtype: list[str]
        """
        return self._datastore_ids

    @datastore_ids.setter
    def datastore_ids(self, datastore_ids):
        """
        Sets the datastore_ids of this DatastoreClusterSummary.
        The `OCIDs`__ of the Datastores that belong to the Datastore Cluster

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param datastore_ids: The datastore_ids of this DatastoreClusterSummary.
        :type: list[str]
        """
        self._datastore_ids = datastore_ids

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DatastoreClusterSummary.
        The `OCID`__ of the compartment that
        contains the Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DatastoreClusterSummary.
        The `OCID`__ of the compartment that
        contains the Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this DatastoreClusterSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DatastoreClusterSummary.
        A descriptive name for the Datastore Cluster. It must be unique within a SDDC, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :return: The display_name of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DatastoreClusterSummary.
        A descriptive name for the Datastore Cluster. It must be unique within a SDDC, start with a letter, and contain only letters, digits,
        whitespaces, dashes and underscores.
        Avoid entering confidential information.


        :param display_name: The display_name of this DatastoreClusterSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def cluster_id(self):
        """
        Gets the cluster_id of this DatastoreClusterSummary.
        The `OCID`__ of the VMware Cluster that Datastore Cluster is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cluster_id of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this DatastoreClusterSummary.
        The `OCID`__ of the VMware Cluster that Datastore Cluster is attached to.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cluster_id: The cluster_id of this DatastoreClusterSummary.
        :type: str
        """
        self._cluster_id = cluster_id

    @property
    def sddc_id(self):
        """
        Gets the sddc_id of this DatastoreClusterSummary.
        The `OCID`__ of the SDDC that Datastore Cluster is associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The sddc_id of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._sddc_id

    @sddc_id.setter
    def sddc_id(self, sddc_id):
        """
        Sets the sddc_id of this DatastoreClusterSummary.
        The `OCID`__ of the SDDC that Datastore Cluster is associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param sddc_id: The sddc_id of this DatastoreClusterSummary.
        :type: str
        """
        self._sddc_id = sddc_id

    @property
    def esxi_host_ids(self):
        """
        Gets the esxi_host_ids of this DatastoreClusterSummary.
        The `OCIDs`__ of the ESXi hosts attached to Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The esxi_host_ids of this DatastoreClusterSummary.
        :rtype: list[str]
        """
        return self._esxi_host_ids

    @esxi_host_ids.setter
    def esxi_host_ids(self, esxi_host_ids):
        """
        Sets the esxi_host_ids of this DatastoreClusterSummary.
        The `OCIDs`__ of the ESXi hosts attached to Datastore Cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param esxi_host_ids: The esxi_host_ids of this DatastoreClusterSummary.
        :type: list[str]
        """
        self._esxi_host_ids = esxi_host_ids

    @property
    def datastore_cluster_type(self):
        """
        Gets the datastore_cluster_type of this DatastoreClusterSummary.
        Type of the datastore cluster.

        Allowed values for this property are: "MANAGEMENT", "WORKLOAD", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The datastore_cluster_type of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._datastore_cluster_type

    @datastore_cluster_type.setter
    def datastore_cluster_type(self, datastore_cluster_type):
        """
        Sets the datastore_cluster_type of this DatastoreClusterSummary.
        Type of the datastore cluster.


        :param datastore_cluster_type: The datastore_cluster_type of this DatastoreClusterSummary.
        :type: str
        """
        allowed_values = ["MANAGEMENT", "WORKLOAD"]
        if not value_allowed_none_or_none_sentinel(datastore_cluster_type, allowed_values):
            datastore_cluster_type = 'UNKNOWN_ENUM_VALUE'
        self._datastore_cluster_type = datastore_cluster_type

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DatastoreClusterSummary.
        The date and time the Datastore Cluster was created, in the format defined by
        `RFC3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this DatastoreClusterSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DatastoreClusterSummary.
        The date and time the Datastore Cluster was created, in the format defined by
        `RFC3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this DatastoreClusterSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DatastoreClusterSummary.
        The current state of the Datastore Cluster.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DatastoreClusterSummary.
        The current state of the Datastore Cluster.


        :param lifecycle_state: The lifecycle_state of this DatastoreClusterSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this DatastoreClusterSummary.
        The availability domain of the Datastore Cluster.


        :return: The availability_domain of this DatastoreClusterSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this DatastoreClusterSummary.
        The availability domain of the Datastore Cluster.


        :param availability_domain: The availability_domain of this DatastoreClusterSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def capacity_in_gbs(self):
        """
        Gets the capacity_in_gbs of this DatastoreClusterSummary.
        Total size of all datastores associated with the datastore cluster in GB.


        :return: The capacity_in_gbs of this DatastoreClusterSummary.
        :rtype: float
        """
        return self._capacity_in_gbs

    @capacity_in_gbs.setter
    def capacity_in_gbs(self, capacity_in_gbs):
        """
        Sets the capacity_in_gbs of this DatastoreClusterSummary.
        Total size of all datastores associated with the datastore cluster in GB.


        :param capacity_in_gbs: The capacity_in_gbs of this DatastoreClusterSummary.
        :type: float
        """
        self._capacity_in_gbs = capacity_in_gbs

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this DatastoreClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DatastoreClusterSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DatastoreClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DatastoreClusterSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this DatastoreClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DatastoreClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DatastoreClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DatastoreClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DatastoreClusterSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :return: The system_tags of this DatastoreClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DatastoreClusterSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{orcl-cloud: {free-tier-retain: true}}`


        :param system_tags: The system_tags of this DatastoreClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
