# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourceAnalyticsInstanceEnableOacDetails(object):
    """
    The configuration details for the enable OAC operation.

    Example: `{\"attachmentType\":\"MANAGED\",\"attachmentDetails\":{...}}`
    """

    #: A constant which can be used with the attachment_type property of a ResourceAnalyticsInstanceEnableOacDetails.
    #: This constant has a value of "MANAGED"
    ATTACHMENT_TYPE_MANAGED = "MANAGED"

    def __init__(self, **kwargs):
        """
        Initializes a new ResourceAnalyticsInstanceEnableOacDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param attachment_type:
            The value to assign to the attachment_type property of this ResourceAnalyticsInstanceEnableOacDetails.
            Allowed values for this property are: "MANAGED"
        :type attachment_type: str

        :param attachment_details:
            The value to assign to the attachment_details property of this ResourceAnalyticsInstanceEnableOacDetails.
        :type attachment_details: oci.resource_analytics.models.ResourceAnalyticsInstanceOacAttachmentDetails

        """
        self.swagger_types = {
            'attachment_type': 'str',
            'attachment_details': 'ResourceAnalyticsInstanceOacAttachmentDetails'
        }
        self.attribute_map = {
            'attachment_type': 'attachmentType',
            'attachment_details': 'attachmentDetails'
        }
        self._attachment_type = None
        self._attachment_details = None

    @property
    def attachment_type(self):
        """
        **[Required]** Gets the attachment_type of this ResourceAnalyticsInstanceEnableOacDetails.
        The type of attachment the OAC instance is using.

        Allowed values for this property are: "MANAGED"


        :return: The attachment_type of this ResourceAnalyticsInstanceEnableOacDetails.
        :rtype: str
        """
        return self._attachment_type

    @attachment_type.setter
    def attachment_type(self, attachment_type):
        """
        Sets the attachment_type of this ResourceAnalyticsInstanceEnableOacDetails.
        The type of attachment the OAC instance is using.


        :param attachment_type: The attachment_type of this ResourceAnalyticsInstanceEnableOacDetails.
        :type: str
        """
        allowed_values = ["MANAGED"]
        if not value_allowed_none_or_none_sentinel(attachment_type, allowed_values):
            raise ValueError(
                f"Invalid value for `attachment_type`, must be None or one of {allowed_values}"
            )
        self._attachment_type = attachment_type

    @property
    def attachment_details(self):
        """
        **[Required]** Gets the attachment_details of this ResourceAnalyticsInstanceEnableOacDetails.

        :return: The attachment_details of this ResourceAnalyticsInstanceEnableOacDetails.
        :rtype: oci.resource_analytics.models.ResourceAnalyticsInstanceOacAttachmentDetails
        """
        return self._attachment_details

    @attachment_details.setter
    def attachment_details(self, attachment_details):
        """
        Sets the attachment_details of this ResourceAnalyticsInstanceEnableOacDetails.

        :param attachment_details: The attachment_details of this ResourceAnalyticsInstanceEnableOacDetails.
        :type: oci.resource_analytics.models.ResourceAnalyticsInstanceOacAttachmentDetails
        """
        self._attachment_details = attachment_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
