# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostVulnerabilityImpactedHostSummary(object):
    """
    Information on a host impacted by a vulnerability
    """

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilityImpactedHostSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilityImpactedHostSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilityImpactedHostSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilityImpactedHostSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilityImpactedHostSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a HostVulnerabilityImpactedHostSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new HostVulnerabilityImpactedHostSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param instance_id:
            The value to assign to the instance_id property of this HostVulnerabilityImpactedHostSummary.
        :type instance_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this HostVulnerabilityImpactedHostSummary.
        :type compartment_id: str

        :param last_agent_scan_id:
            The value to assign to the last_agent_scan_id property of this HostVulnerabilityImpactedHostSummary.
        :type last_agent_scan_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HostVulnerabilityImpactedHostSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'instance_id': 'str',
            'compartment_id': 'str',
            'last_agent_scan_id': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'instance_id': 'instanceId',
            'compartment_id': 'compartmentId',
            'last_agent_scan_id': 'lastAgentScanId',
            'lifecycle_state': 'lifecycleState'
        }
        self._instance_id = None
        self._compartment_id = None
        self._last_agent_scan_id = None
        self._lifecycle_state = None

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this HostVulnerabilityImpactedHostSummary.
        The compute instance ID of the impacted host


        :return: The instance_id of this HostVulnerabilityImpactedHostSummary.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this HostVulnerabilityImpactedHostSummary.
        The compute instance ID of the impacted host


        :param instance_id: The instance_id of this HostVulnerabilityImpactedHostSummary.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this HostVulnerabilityImpactedHostSummary.
        The compartment ID of the impacted host


        :return: The compartment_id of this HostVulnerabilityImpactedHostSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this HostVulnerabilityImpactedHostSummary.
        The compartment ID of the impacted host


        :param compartment_id: The compartment_id of this HostVulnerabilityImpactedHostSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def last_agent_scan_id(self):
        """
        **[Required]** Gets the last_agent_scan_id of this HostVulnerabilityImpactedHostSummary.
        The ID of the last host agent scan result


        :return: The last_agent_scan_id of this HostVulnerabilityImpactedHostSummary.
        :rtype: str
        """
        return self._last_agent_scan_id

    @last_agent_scan_id.setter
    def last_agent_scan_id(self, last_agent_scan_id):
        """
        Sets the last_agent_scan_id of this HostVulnerabilityImpactedHostSummary.
        The ID of the last host agent scan result


        :param last_agent_scan_id: The last_agent_scan_id of this HostVulnerabilityImpactedHostSummary.
        :type: str
        """
        self._last_agent_scan_id = last_agent_scan_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this HostVulnerabilityImpactedHostSummary.
        The current state of the resource.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this HostVulnerabilityImpactedHostSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HostVulnerabilityImpactedHostSummary.
        The current state of the resource.


        :param lifecycle_state: The lifecycle_state of this HostVulnerabilityImpactedHostSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
