# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BackupSummary(object):
    """
    The information of a backup for the server.
    """

    #: A constant which can be used with the type property of a BackupSummary.
    #: This constant has a value of "LOCAL_FILE"
    TYPE_LOCAL_FILE = "LOCAL_FILE"

    #: A constant which can be used with the content_type property of a BackupSummary.
    #: This constant has a value of "BINARY"
    CONTENT_TYPE_BINARY = "BINARY"

    def __init__(self, **kwargs):
        """
        Initializes a new BackupSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this BackupSummary.
        :type id: str

        :param type:
            The value to assign to the type property of this BackupSummary.
            Allowed values for this property are: "LOCAL_FILE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param managed_instance_id:
            The value to assign to the managed_instance_id property of this BackupSummary.
        :type managed_instance_id: str

        :param backup_location:
            The value to assign to the backup_location property of this BackupSummary.
        :type backup_location: str

        :param content_type:
            The value to assign to the content_type property of this BackupSummary.
            Allowed values for this property are: "BINARY", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type content_type: str

        :param time_created:
            The value to assign to the time_created property of this BackupSummary.
        :type time_created: datetime

        """
        self.swagger_types = {
            'id': 'str',
            'type': 'str',
            'managed_instance_id': 'str',
            'backup_location': 'str',
            'content_type': 'str',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'id': 'id',
            'type': 'type',
            'managed_instance_id': 'managedInstanceId',
            'backup_location': 'backupLocation',
            'content_type': 'contentType',
            'time_created': 'timeCreated'
        }
        self._id = None
        self._type = None
        self._managed_instance_id = None
        self._backup_location = None
        self._content_type = None
        self._time_created = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this BackupSummary.
        The unique identifier of the backup.

        **Note:** Not an `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this BackupSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this BackupSummary.
        The unique identifier of the backup.

        **Note:** Not an `OCID`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this BackupSummary.
        :type: str
        """
        self._id = id

    @property
    def type(self):
        """
        **[Required]** Gets the type of this BackupSummary.
        The type of the backup.

        Allowed values for this property are: "LOCAL_FILE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this BackupSummary.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this BackupSummary.
        The type of the backup.


        :param type: The type of this BackupSummary.
        :type: str
        """
        allowed_values = ["LOCAL_FILE"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def managed_instance_id(self):
        """
        Gets the managed_instance_id of this BackupSummary.
        The managed instance ID of the server for which the backup was created.


        :return: The managed_instance_id of this BackupSummary.
        :rtype: str
        """
        return self._managed_instance_id

    @managed_instance_id.setter
    def managed_instance_id(self, managed_instance_id):
        """
        Sets the managed_instance_id of this BackupSummary.
        The managed instance ID of the server for which the backup was created.


        :param managed_instance_id: The managed_instance_id of this BackupSummary.
        :type: str
        """
        self._managed_instance_id = managed_instance_id

    @property
    def backup_location(self):
        """
        **[Required]** Gets the backup_location of this BackupSummary.
        The location of the backup. For backups of type LOCAL_FILE this is the absolute path of the backup file.


        :return: The backup_location of this BackupSummary.
        :rtype: str
        """
        return self._backup_location

    @backup_location.setter
    def backup_location(self, backup_location):
        """
        Sets the backup_location of this BackupSummary.
        The location of the backup. For backups of type LOCAL_FILE this is the absolute path of the backup file.


        :param backup_location: The backup_location of this BackupSummary.
        :type: str
        """
        self._backup_location = backup_location

    @property
    def content_type(self):
        """
        Gets the content_type of this BackupSummary.
        The type of content of the backup.

        Allowed values for this property are: "BINARY", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The content_type of this BackupSummary.
        :rtype: str
        """
        return self._content_type

    @content_type.setter
    def content_type(self, content_type):
        """
        Sets the content_type of this BackupSummary.
        The type of content of the backup.


        :param content_type: The content_type of this BackupSummary.
        :type: str
        """
        allowed_values = ["BINARY"]
        if not value_allowed_none_or_none_sentinel(content_type, allowed_values):
            content_type = 'UNKNOWN_ENUM_VALUE'
        self._content_type = content_type

    @property
    def time_created(self):
        """
        Gets the time_created of this BackupSummary.
        The date and time when the backup was created (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_created of this BackupSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this BackupSummary.
        The date and time when the backup was created (in `RFC 3339`__ format).

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_created: The time_created of this BackupSummary.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
