# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221109


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class NormalizationFields(object):
    """
    A string-to-object map where the key is the normalization field and the object contains information about the field.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new NormalizationFields object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param map:
            The value to assign to the map property of this NormalizationFields.
        :type map: dict(str, NormalizationFieldsMapValue)

        """
        self.swagger_types = {
            'map': 'dict(str, NormalizationFieldsMapValue)'
        }
        self.attribute_map = {
            'map': 'map'
        }
        self._map = None

    @property
    def map(self):
        """
        Gets the map of this NormalizationFields.
        A wrapped map.


        :return: The map of this NormalizationFields.
        :rtype: dict(str, NormalizationFieldsMapValue)
        """
        return self._map

    @map.setter
    def map(self, map):
        """
        Sets the map of this NormalizationFields.
        A wrapped map.


        :param map: The map of this NormalizationFields.
        :type: dict(str, NormalizationFieldsMapValue)
        """
        self._map = map

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
