# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HealthEntityDocumentResult(object):
    """
    The document response for health entity detect call.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new HealthEntityDocumentResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this HealthEntityDocumentResult.
        :type key: str

        :param entities:
            The value to assign to the entities property of this HealthEntityDocumentResult.
        :type entities: list[oci.ai_language.models.HealthEntity]

        :param relations:
            The value to assign to the relations property of this HealthEntityDocumentResult.
        :type relations: list[oci.ai_language.models.RelationEntity]

        :param resolved_entities:
            The value to assign to the resolved_entities property of this HealthEntityDocumentResult.
        :type resolved_entities: dict(str, ResolvedEntities)

        :param language_code:
            The value to assign to the language_code property of this HealthEntityDocumentResult.
        :type language_code: str

        """
        self.swagger_types = {
            'key': 'str',
            'entities': 'list[HealthEntity]',
            'relations': 'list[RelationEntity]',
            'resolved_entities': 'dict(str, ResolvedEntities)',
            'language_code': 'str'
        }
        self.attribute_map = {
            'key': 'key',
            'entities': 'entities',
            'relations': 'relations',
            'resolved_entities': 'resolvedEntities',
            'language_code': 'languageCode'
        }
        self._key = None
        self._entities = None
        self._relations = None
        self._resolved_entities = None
        self._language_code = None

    @property
    def key(self):
        """
        **[Required]** Gets the key of this HealthEntityDocumentResult.
        Document unique identifier defined by the user.


        :return: The key of this HealthEntityDocumentResult.
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """
        Sets the key of this HealthEntityDocumentResult.
        Document unique identifier defined by the user.


        :param key: The key of this HealthEntityDocumentResult.
        :type: str
        """
        self._key = key

    @property
    def entities(self):
        """
        **[Required]** Gets the entities of this HealthEntityDocumentResult.
        List of detected entities.


        :return: The entities of this HealthEntityDocumentResult.
        :rtype: list[oci.ai_language.models.HealthEntity]
        """
        return self._entities

    @entities.setter
    def entities(self, entities):
        """
        Sets the entities of this HealthEntityDocumentResult.
        List of detected entities.


        :param entities: The entities of this HealthEntityDocumentResult.
        :type: list[oci.ai_language.models.HealthEntity]
        """
        self._entities = entities

    @property
    def relations(self):
        """
        Gets the relations of this HealthEntityDocumentResult.
        List of succeeded document response.


        :return: The relations of this HealthEntityDocumentResult.
        :rtype: list[oci.ai_language.models.RelationEntity]
        """
        return self._relations

    @relations.setter
    def relations(self, relations):
        """
        Sets the relations of this HealthEntityDocumentResult.
        List of succeeded document response.


        :param relations: The relations of this HealthEntityDocumentResult.
        :type: list[oci.ai_language.models.RelationEntity]
        """
        self._relations = relations

    @property
    def resolved_entities(self):
        """
        **[Required]** Gets the resolved_entities of this HealthEntityDocumentResult.
        Map of resolved entities by entity type


        :return: The resolved_entities of this HealthEntityDocumentResult.
        :rtype: dict(str, ResolvedEntities)
        """
        return self._resolved_entities

    @resolved_entities.setter
    def resolved_entities(self, resolved_entities):
        """
        Sets the resolved_entities of this HealthEntityDocumentResult.
        Map of resolved entities by entity type


        :param resolved_entities: The resolved_entities of this HealthEntityDocumentResult.
        :type: dict(str, ResolvedEntities)
        """
        self._resolved_entities = resolved_entities

    @property
    def language_code(self):
        """
        **[Required]** Gets the language_code of this HealthEntityDocumentResult.
        Language code of the document. Please refer to respective model `API documentation`__ for supported languages.

        __ https://docs.cloud.oracle.com/iaas/language/using/overview.htm


        :return: The language_code of this HealthEntityDocumentResult.
        :rtype: str
        """
        return self._language_code

    @language_code.setter
    def language_code(self, language_code):
        """
        Sets the language_code of this HealthEntityDocumentResult.
        Language code of the document. Please refer to respective model `API documentation`__ for supported languages.

        __ https://docs.cloud.oracle.com/iaas/language/using/overview.htm


        :param language_code: The language_code of this HealthEntityDocumentResult.
        :type: str
        """
        self._language_code = language_code

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
