# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class StreamGroupOverlap(object):
    """
    List of streamSource OCIDs that have overlapping fields of view
    """

    def __init__(self, **kwargs):
        """
        Initializes a new StreamGroupOverlap object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param overlapping_streams:
            The value to assign to the overlapping_streams property of this StreamGroupOverlap.
        :type overlapping_streams: list[str]

        """
        self.swagger_types = {
            'overlapping_streams': 'list[str]'
        }
        self.attribute_map = {
            'overlapping_streams': 'overlappingStreams'
        }
        self._overlapping_streams = None

    @property
    def overlapping_streams(self):
        """
        Gets the overlapping_streams of this StreamGroupOverlap.
        List of streamSource OCIDs.


        :return: The overlapping_streams of this StreamGroupOverlap.
        :rtype: list[str]
        """
        return self._overlapping_streams

    @overlapping_streams.setter
    def overlapping_streams(self, overlapping_streams):
        """
        Sets the overlapping_streams of this StreamGroupOverlap.
        List of streamSource OCIDs.


        :param overlapping_streams: The overlapping_streams of this StreamGroupOverlap.
        :type: list[str]
        """
        self._overlapping_streams = overlapping_streams

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
