# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TrackingType(object):
    """
    Details of what to track.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TrackingType object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param objects:
            The value to assign to the objects property of this TrackingType.
        :type objects: list[str]

        :param detection_model_id:
            The value to assign to the detection_model_id property of this TrackingType.
        :type detection_model_id: str

        :param tracking_model_id:
            The value to assign to the tracking_model_id property of this TrackingType.
        :type tracking_model_id: str

        :param max_results:
            The value to assign to the max_results property of this TrackingType.
        :type max_results: int

        :param should_return_landmarks:
            The value to assign to the should_return_landmarks property of this TrackingType.
        :type should_return_landmarks: bool

        """
        self.swagger_types = {
            'objects': 'list[str]',
            'detection_model_id': 'str',
            'tracking_model_id': 'str',
            'max_results': 'int',
            'should_return_landmarks': 'bool'
        }
        self.attribute_map = {
            'objects': 'objects',
            'detection_model_id': 'detectionModelId',
            'tracking_model_id': 'trackingModelId',
            'max_results': 'maxResults',
            'should_return_landmarks': 'shouldReturnLandmarks'
        }
        self._objects = None
        self._detection_model_id = None
        self._tracking_model_id = None
        self._max_results = None
        self._should_return_landmarks = None

    @property
    def objects(self):
        """
        **[Required]** Gets the objects of this TrackingType.
        List of the objects to be tracked.


        :return: The objects of this TrackingType.
        :rtype: list[str]
        """
        return self._objects

    @objects.setter
    def objects(self, objects):
        """
        Sets the objects of this TrackingType.
        List of the objects to be tracked.


        :param objects: The objects of this TrackingType.
        :type: list[str]
        """
        self._objects = objects

    @property
    def detection_model_id(self):
        """
        Gets the detection_model_id of this TrackingType.
        The detection model OCID.


        :return: The detection_model_id of this TrackingType.
        :rtype: str
        """
        return self._detection_model_id

    @detection_model_id.setter
    def detection_model_id(self, detection_model_id):
        """
        Sets the detection_model_id of this TrackingType.
        The detection model OCID.


        :param detection_model_id: The detection_model_id of this TrackingType.
        :type: str
        """
        self._detection_model_id = detection_model_id

    @property
    def tracking_model_id(self):
        """
        Gets the tracking_model_id of this TrackingType.
        The tracking model OCID.


        :return: The tracking_model_id of this TrackingType.
        :rtype: str
        """
        return self._tracking_model_id

    @tracking_model_id.setter
    def tracking_model_id(self, tracking_model_id):
        """
        Sets the tracking_model_id of this TrackingType.
        The tracking model OCID.


        :param tracking_model_id: The tracking_model_id of this TrackingType.
        :type: str
        """
        self._tracking_model_id = tracking_model_id

    @property
    def max_results(self):
        """
        Gets the max_results of this TrackingType.
        The maximum number of results to return.


        :return: The max_results of this TrackingType.
        :rtype: int
        """
        return self._max_results

    @max_results.setter
    def max_results(self, max_results):
        """
        Sets the max_results of this TrackingType.
        The maximum number of results to return.


        :param max_results: The max_results of this TrackingType.
        :type: int
        """
        self._max_results = max_results

    @property
    def should_return_landmarks(self):
        """
        Gets the should_return_landmarks of this TrackingType.
        Whether or not return face landmarks.


        :return: The should_return_landmarks of this TrackingType.
        :rtype: bool
        """
        return self._should_return_landmarks

    @should_return_landmarks.setter
    def should_return_landmarks(self, should_return_landmarks):
        """
        Sets the should_return_landmarks of this TrackingType.
        Whether or not return face landmarks.


        :param should_return_landmarks: The should_return_landmarks of this TrackingType.
        :type: bool
        """
        self._should_return_landmarks = should_return_landmarks

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
