# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateStreamJobDetails(object):
    """
    The information needed to update streamjob
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateStreamJobDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param stream_source_id:
            The value to assign to the stream_source_id property of this UpdateStreamJobDetails.
        :type stream_source_id: str

        :param features:
            The value to assign to the features property of this UpdateStreamJobDetails.
        :type features: list[oci.ai_vision.models.VideoStreamFeature]

        :param stream_output_location:
            The value to assign to the stream_output_location property of this UpdateStreamJobDetails.
        :type stream_output_location: oci.ai_vision.models.StreamOutputLocation

        :param display_name:
            The value to assign to the display_name property of this UpdateStreamJobDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateStreamJobDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateStreamJobDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'stream_source_id': 'str',
            'features': 'list[VideoStreamFeature]',
            'stream_output_location': 'StreamOutputLocation',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'stream_source_id': 'streamSourceId',
            'features': 'features',
            'stream_output_location': 'streamOutputLocation',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._stream_source_id = None
        self._features = None
        self._stream_output_location = None
        self._display_name = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def stream_source_id(self):
        """
        Gets the stream_source_id of this UpdateStreamJobDetails.
        `OCID`__ of streamSource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The stream_source_id of this UpdateStreamJobDetails.
        :rtype: str
        """
        return self._stream_source_id

    @stream_source_id.setter
    def stream_source_id(self, stream_source_id):
        """
        Sets the stream_source_id of this UpdateStreamJobDetails.
        `OCID`__ of streamSource

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param stream_source_id: The stream_source_id of this UpdateStreamJobDetails.
        :type: str
        """
        self._stream_source_id = stream_source_id

    @property
    def features(self):
        """
        Gets the features of this UpdateStreamJobDetails.
        List of stream analysis features.


        :return: The features of this UpdateStreamJobDetails.
        :rtype: list[oci.ai_vision.models.VideoStreamFeature]
        """
        return self._features

    @features.setter
    def features(self, features):
        """
        Sets the features of this UpdateStreamJobDetails.
        List of stream analysis features.


        :param features: The features of this UpdateStreamJobDetails.
        :type: list[oci.ai_vision.models.VideoStreamFeature]
        """
        self._features = features

    @property
    def stream_output_location(self):
        """
        Gets the stream_output_location of this UpdateStreamJobDetails.

        :return: The stream_output_location of this UpdateStreamJobDetails.
        :rtype: oci.ai_vision.models.StreamOutputLocation
        """
        return self._stream_output_location

    @stream_output_location.setter
    def stream_output_location(self, stream_output_location):
        """
        Sets the stream_output_location of this UpdateStreamJobDetails.

        :param stream_output_location: The stream_output_location of this UpdateStreamJobDetails.
        :type: oci.ai_vision.models.StreamOutputLocation
        """
        self._stream_output_location = stream_output_location

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateStreamJobDetails.
        Stream job display name.


        :return: The display_name of this UpdateStreamJobDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateStreamJobDetails.
        Stream job display name.


        :param display_name: The display_name of this UpdateStreamJobDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateStreamJobDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateStreamJobDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateStreamJobDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. It exists for cross-compatibility only.
        For example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateStreamJobDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateStreamJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateStreamJobDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateStreamJobDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateStreamJobDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
