# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AgentConfigOverrides(object):
    """
    Agent configuration overrides that should apply to a subset of the agents associated with an Agent Config object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AgentConfigOverrides object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param override_list:
            The value to assign to the override_list property of this AgentConfigOverrides.
        :type override_list: list[oci.apm_config.models.AgentConfigOverride]

        """
        self.swagger_types = {
            'override_list': 'list[AgentConfigOverride]'
        }
        self.attribute_map = {
            'override_list': 'overrideList'
        }
        self._override_list = None

    @property
    def override_list(self):
        """
        Gets the override_list of this AgentConfigOverrides.

        :return: The override_list of this AgentConfigOverrides.
        :rtype: list[oci.apm_config.models.AgentConfigOverride]
        """
        return self._override_list

    @override_list.setter
    def override_list(self, override_list):
        """
        Sets the override_list of this AgentConfigOverrides.

        :param override_list: The override_list of this AgentConfigOverrides.
        :type: list[oci.apm_config.models.AgentConfigOverride]
        """
        self._override_list = override_list

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
