# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportConfigurationFailedItemSummary(object):
    """
    A configuration item that failed to be imported.
    """

    #: A constant which can be used with the config_type property of a ImportConfigurationFailedItemSummary.
    #: This constant has a value of "SPAN_FILTER"
    CONFIG_TYPE_SPAN_FILTER = "SPAN_FILTER"

    #: A constant which can be used with the config_type property of a ImportConfigurationFailedItemSummary.
    #: This constant has a value of "METRIC_GROUP"
    CONFIG_TYPE_METRIC_GROUP = "METRIC_GROUP"

    #: A constant which can be used with the config_type property of a ImportConfigurationFailedItemSummary.
    #: This constant has a value of "APDEX"
    CONFIG_TYPE_APDEX = "APDEX"

    #: A constant which can be used with the config_type property of a ImportConfigurationFailedItemSummary.
    #: This constant has a value of "OPTIONS"
    CONFIG_TYPE_OPTIONS = "OPTIONS"

    #: A constant which can be used with the config_type property of a ImportConfigurationFailedItemSummary.
    #: This constant has a value of "AGENT"
    CONFIG_TYPE_AGENT = "AGENT"

    #: A constant which can be used with the config_type property of a ImportConfigurationFailedItemSummary.
    #: This constant has a value of "MACS_APM_EXTENSION"
    CONFIG_TYPE_MACS_APM_EXTENSION = "MACS_APM_EXTENSION"

    def __init__(self, **kwargs):
        """
        Initializes a new ImportConfigurationFailedItemSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ImportConfigurationFailedItemSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ImportConfigurationFailedItemSummary.
        :type display_name: str

        :param error_message:
            The value to assign to the error_message property of this ImportConfigurationFailedItemSummary.
        :type error_message: str

        :param config_type:
            The value to assign to the config_type property of this ImportConfigurationFailedItemSummary.
            Allowed values for this property are: "SPAN_FILTER", "METRIC_GROUP", "APDEX", "OPTIONS", "AGENT", "MACS_APM_EXTENSION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type config_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'error_message': 'str',
            'config_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'error_message': 'errorMessage',
            'config_type': 'configType'
        }
        self._id = None
        self._display_name = None
        self._error_message = None
        self._config_type = None

    @property
    def id(self):
        """
        Gets the id of this ImportConfigurationFailedItemSummary.
        The `OCID`__ of the configuration item. An OCID is generated
        when the item is created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this ImportConfigurationFailedItemSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ImportConfigurationFailedItemSummary.
        The `OCID`__ of the configuration item. An OCID is generated
        when the item is created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this ImportConfigurationFailedItemSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this ImportConfigurationFailedItemSummary.
        The name by which a configuration entity is displayed to the end user.


        :return: The display_name of this ImportConfigurationFailedItemSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ImportConfigurationFailedItemSummary.
        The name by which a configuration entity is displayed to the end user.


        :param display_name: The display_name of this ImportConfigurationFailedItemSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def error_message(self):
        """
        Gets the error_message of this ImportConfigurationFailedItemSummary.
        The configuration item wasn't imported due to it being a duplicate.


        :return: The error_message of this ImportConfigurationFailedItemSummary.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message):
        """
        Sets the error_message of this ImportConfigurationFailedItemSummary.
        The configuration item wasn't imported due to it being a duplicate.


        :param error_message: The error_message of this ImportConfigurationFailedItemSummary.
        :type: str
        """
        self._error_message = error_message

    @property
    def config_type(self):
        """
        Gets the config_type of this ImportConfigurationFailedItemSummary.
        The type of configuration item.

        Allowed values for this property are: "SPAN_FILTER", "METRIC_GROUP", "APDEX", "OPTIONS", "AGENT", "MACS_APM_EXTENSION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The config_type of this ImportConfigurationFailedItemSummary.
        :rtype: str
        """
        return self._config_type

    @config_type.setter
    def config_type(self, config_type):
        """
        Sets the config_type of this ImportConfigurationFailedItemSummary.
        The type of configuration item.


        :param config_type: The config_type of this ImportConfigurationFailedItemSummary.
        :type: str
        """
        allowed_values = ["SPAN_FILTER", "METRIC_GROUP", "APDEX", "OPTIONS", "AGENT", "MACS_APM_EXTENSION"]
        if not value_allowed_none_or_none_sentinel(config_type, allowed_values):
            config_type = 'UNKNOWN_ENUM_VALUE'
        self._config_type = config_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
