# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class BdsCapacityReport(object):
    """
    A report of the host capacity within an availability domain that is available for you to create bds clusters. Host capacity is the physical infrastructure that resources such as compute instances run on. Use the capacity report to determine whether sufficient capacity is available for a shape before you create a bds cluster or change the shape of a bds cluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new BdsCapacityReport object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this BdsCapacityReport.
        :type compartment_id: str

        :param shape_availabilities:
            The value to assign to the shape_availabilities property of this BdsCapacityReport.
        :type shape_availabilities: list[oci.bds.models.CapacityReportShapeAvailability]

        :param time_created:
            The value to assign to the time_created property of this BdsCapacityReport.
        :type time_created: datetime

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'shape_availabilities': 'list[CapacityReportShapeAvailability]',
            'time_created': 'datetime'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'shape_availabilities': 'shapeAvailabilities',
            'time_created': 'timeCreated'
        }
        self._compartment_id = None
        self._shape_availabilities = None
        self._time_created = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this BdsCapacityReport.
        The OCID for the compartment. This should always be the root compartment.


        :return: The compartment_id of this BdsCapacityReport.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this BdsCapacityReport.
        The OCID for the compartment. This should always be the root compartment.


        :param compartment_id: The compartment_id of this BdsCapacityReport.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def shape_availabilities(self):
        """
        **[Required]** Gets the shape_availabilities of this BdsCapacityReport.
        Information about the capacity of each requested shape.


        :return: The shape_availabilities of this BdsCapacityReport.
        :rtype: list[oci.bds.models.CapacityReportShapeAvailability]
        """
        return self._shape_availabilities

    @shape_availabilities.setter
    def shape_availabilities(self, shape_availabilities):
        """
        Sets the shape_availabilities of this BdsCapacityReport.
        Information about the capacity of each requested shape.


        :param shape_availabilities: The shape_availabilities of this BdsCapacityReport.
        :type: list[oci.bds.models.CapacityReportShapeAvailability]
        """
        self._shape_availabilities = shape_availabilities

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this BdsCapacityReport.
        The time the report was created, shown as an RFC 3339 formatted datetime string.


        :return: The time_created of this BdsCapacityReport.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this BdsCapacityReport.
        The time the report was created, shown as an RFC 3339 formatted datetime string.


        :param time_created: The time_created of this BdsCapacityReport.
        :type: datetime
        """
        self._time_created = time_created

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
