# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IdentityConfigurationSummary(object):
    """
    Summary of the identity config
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IdentityConfigurationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this IdentityConfigurationSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this IdentityConfigurationSummary.
        :type display_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this IdentityConfigurationSummary.
        :type lifecycle_state: str

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'lifecycle_state': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'lifecycle_state': 'lifecycleState'
        }
        self._id = None
        self._display_name = None
        self._lifecycle_state = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this IdentityConfigurationSummary.
        The id of the identity config


        :return: The id of this IdentityConfigurationSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IdentityConfigurationSummary.
        The id of the identity config


        :param id: The id of this IdentityConfigurationSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this IdentityConfigurationSummary.
        Display name of the identity config


        :return: The display_name of this IdentityConfigurationSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this IdentityConfigurationSummary.
        Display name of the identity config


        :param display_name: The display_name of this IdentityConfigurationSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this IdentityConfigurationSummary.
        Lifecycle state of the identity config


        :return: The lifecycle_state of this IdentityConfigurationSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this IdentityConfigurationSummary.
        Lifecycle state of the identity config


        :param lifecycle_state: The lifecycle_state of this IdentityConfigurationSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
