# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CostAnomalyMonitor(object):
    """
    A CostAnomalyMonitor.
    """

    #: A constant which can be used with the type property of a CostAnomalyMonitor.
    #: This constant has a value of "DEFAULT"
    TYPE_DEFAULT = "DEFAULT"

    #: A constant which can be used with the type property of a CostAnomalyMonitor.
    #: This constant has a value of "CUSTOM"
    TYPE_CUSTOM = "CUSTOM"

    #: A constant which can be used with the lifecycle_state property of a CostAnomalyMonitor.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CostAnomalyMonitor.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CostAnomalyMonitor.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    def __init__(self, **kwargs):
        """
        Initializes a new CostAnomalyMonitor object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CostAnomalyMonitor.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CostAnomalyMonitor.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CostAnomalyMonitor.
        :type name: str

        :param type:
            The value to assign to the type property of this CostAnomalyMonitor.
            Allowed values for this property are: "DEFAULT", "CUSTOM", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param description:
            The value to assign to the description property of this CostAnomalyMonitor.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CostAnomalyMonitor.
            Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CostAnomalyMonitor.
        :type lifecycle_details: str

        :param target_resource_filter:
            The value to assign to the target_resource_filter property of this CostAnomalyMonitor.
        :type target_resource_filter: oci.budget.models.TargetResourceFilter

        :param cost_alert_subscription_map:
            The value to assign to the cost_alert_subscription_map property of this CostAnomalyMonitor.
        :type cost_alert_subscription_map: oci.budget.models.CostAlertSubscriptionMap

        :param time_created:
            The value to assign to the time_created property of this CostAnomalyMonitor.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CostAnomalyMonitor.
        :type time_updated: datetime

        :param defined_tags:
            The value to assign to the defined_tags property of this CostAnomalyMonitor.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CostAnomalyMonitor.
        :type freeform_tags: dict(str, str)

        :param system_tags:
            The value to assign to the system_tags property of this CostAnomalyMonitor.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'name': 'str',
            'type': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'target_resource_filter': 'TargetResourceFilter',
            'cost_alert_subscription_map': 'CostAlertSubscriptionMap',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'name': 'name',
            'type': 'type',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'target_resource_filter': 'targetResourceFilter',
            'cost_alert_subscription_map': 'costAlertSubscriptionMap',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._name = None
        self._type = None
        self._description = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._target_resource_filter = None
        self._cost_alert_subscription_map = None
        self._time_created = None
        self._time_updated = None
        self._defined_tags = None
        self._freeform_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CostAnomalyMonitor.
        The OCID of the Cost Anomaly Monitor.


        :return: The id of this CostAnomalyMonitor.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CostAnomalyMonitor.
        The OCID of the Cost Anomaly Monitor.


        :param id: The id of this CostAnomalyMonitor.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CostAnomalyMonitor.
        The OCID of the compartment.


        :return: The compartment_id of this CostAnomalyMonitor.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CostAnomalyMonitor.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this CostAnomalyMonitor.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CostAnomalyMonitor.
        The name of the cost anomaly monitor. Avoid entering confidential information.


        :return: The name of this CostAnomalyMonitor.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CostAnomalyMonitor.
        The name of the cost anomaly monitor. Avoid entering confidential information.


        :param name: The name of this CostAnomalyMonitor.
        :type: str
        """
        self._name = name

    @property
    def type(self):
        """
        Gets the type of this CostAnomalyMonitor.
        Type of cost monitor

        Allowed values for this property are: "DEFAULT", "CUSTOM", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this CostAnomalyMonitor.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CostAnomalyMonitor.
        Type of cost monitor


        :param type: The type of this CostAnomalyMonitor.
        :type: str
        """
        allowed_values = ["DEFAULT", "CUSTOM"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def description(self):
        """
        Gets the description of this CostAnomalyMonitor.
        The description of the budget.


        :return: The description of this CostAnomalyMonitor.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CostAnomalyMonitor.
        The description of the budget.


        :param description: The description of this CostAnomalyMonitor.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CostAnomalyMonitor.
        The current state of the cost monitor.

        Allowed values for this property are: "ACTIVE", "INACTIVE", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this CostAnomalyMonitor.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CostAnomalyMonitor.
        The current state of the cost monitor.


        :param lifecycle_state: The lifecycle_state of this CostAnomalyMonitor.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this CostAnomalyMonitor.
        The current state details of the cost monitor.


        :return: The lifecycle_details of this CostAnomalyMonitor.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CostAnomalyMonitor.
        The current state details of the cost monitor.


        :param lifecycle_details: The lifecycle_details of this CostAnomalyMonitor.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def target_resource_filter(self):
        """
        **[Required]** Gets the target_resource_filter of this CostAnomalyMonitor.

        :return: The target_resource_filter of this CostAnomalyMonitor.
        :rtype: oci.budget.models.TargetResourceFilter
        """
        return self._target_resource_filter

    @target_resource_filter.setter
    def target_resource_filter(self, target_resource_filter):
        """
        Sets the target_resource_filter of this CostAnomalyMonitor.

        :param target_resource_filter: The target_resource_filter of this CostAnomalyMonitor.
        :type: oci.budget.models.TargetResourceFilter
        """
        self._target_resource_filter = target_resource_filter

    @property
    def cost_alert_subscription_map(self):
        """
        Gets the cost_alert_subscription_map of this CostAnomalyMonitor.

        :return: The cost_alert_subscription_map of this CostAnomalyMonitor.
        :rtype: oci.budget.models.CostAlertSubscriptionMap
        """
        return self._cost_alert_subscription_map

    @cost_alert_subscription_map.setter
    def cost_alert_subscription_map(self, cost_alert_subscription_map):
        """
        Sets the cost_alert_subscription_map of this CostAnomalyMonitor.

        :param cost_alert_subscription_map: The cost_alert_subscription_map of this CostAnomalyMonitor.
        :type: oci.budget.models.CostAlertSubscriptionMap
        """
        self._cost_alert_subscription_map = cost_alert_subscription_map

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CostAnomalyMonitor.
        The time that the cost monitor was created.


        :return: The time_created of this CostAnomalyMonitor.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CostAnomalyMonitor.
        The time that the cost monitor was created.


        :param time_created: The time_created of this CostAnomalyMonitor.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CostAnomalyMonitor.
        The time that the cost monitor was last updated.


        :return: The time_updated of this CostAnomalyMonitor.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CostAnomalyMonitor.
        The time that the cost monitor was last updated.


        :param time_updated: The time_updated of this CostAnomalyMonitor.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CostAnomalyMonitor.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CostAnomalyMonitor.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CostAnomalyMonitor.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CostAnomalyMonitor.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CostAnomalyMonitor.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CostAnomalyMonitor.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CostAnomalyMonitor.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CostAnomalyMonitor.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CostAnomalyMonitor.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this CostAnomalyMonitor.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CostAnomalyMonitor.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this CostAnomalyMonitor.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
