# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190111


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCostAnomalyMonitorDetails(object):
    """
    The create CostAnomalyMonitor details.
    The clients should pass ocid of the compartmentId for the monitor resource to be created. tenantIdFilter and resourceFilter
    targets resources to monitor in a given tenancy.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCostAnomalyMonitorDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateCostAnomalyMonitorDetails.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this CreateCostAnomalyMonitorDetails.
        :type name: str

        :param description:
            The value to assign to the description property of this CreateCostAnomalyMonitorDetails.
        :type description: str

        :param target_resource_filter:
            The value to assign to the target_resource_filter property of this CreateCostAnomalyMonitorDetails.
        :type target_resource_filter: oci.budget.models.TargetResourceFilter

        :param cost_alert_subscription_map:
            The value to assign to the cost_alert_subscription_map property of this CreateCostAnomalyMonitorDetails.
        :type cost_alert_subscription_map: oci.budget.models.CostAlertSubscriptionMap

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCostAnomalyMonitorDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCostAnomalyMonitorDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'name': 'str',
            'description': 'str',
            'target_resource_filter': 'TargetResourceFilter',
            'cost_alert_subscription_map': 'CostAlertSubscriptionMap',
            'defined_tags': 'dict(str, dict(str, object))',
            'freeform_tags': 'dict(str, str)'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'name': 'name',
            'description': 'description',
            'target_resource_filter': 'targetResourceFilter',
            'cost_alert_subscription_map': 'costAlertSubscriptionMap',
            'defined_tags': 'definedTags',
            'freeform_tags': 'freeformTags'
        }
        self._compartment_id = None
        self._name = None
        self._description = None
        self._target_resource_filter = None
        self._cost_alert_subscription_map = None
        self._defined_tags = None
        self._freeform_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateCostAnomalyMonitorDetails.
        The OCID of the compartment.


        :return: The compartment_id of this CreateCostAnomalyMonitorDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateCostAnomalyMonitorDetails.
        The OCID of the compartment.


        :param compartment_id: The compartment_id of this CreateCostAnomalyMonitorDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateCostAnomalyMonitorDetails.
        The name of the cost anomaly monitor. Avoid entering confidential information.


        :return: The name of this CreateCostAnomalyMonitorDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateCostAnomalyMonitorDetails.
        The name of the cost anomaly monitor. Avoid entering confidential information.


        :param name: The name of this CreateCostAnomalyMonitorDetails.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CreateCostAnomalyMonitorDetails.
        The description of the cost anomaly monitor.


        :return: The description of this CreateCostAnomalyMonitorDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateCostAnomalyMonitorDetails.
        The description of the cost anomaly monitor.


        :param description: The description of this CreateCostAnomalyMonitorDetails.
        :type: str
        """
        self._description = description

    @property
    def target_resource_filter(self):
        """
        **[Required]** Gets the target_resource_filter of this CreateCostAnomalyMonitorDetails.

        :return: The target_resource_filter of this CreateCostAnomalyMonitorDetails.
        :rtype: oci.budget.models.TargetResourceFilter
        """
        return self._target_resource_filter

    @target_resource_filter.setter
    def target_resource_filter(self, target_resource_filter):
        """
        Sets the target_resource_filter of this CreateCostAnomalyMonitorDetails.

        :param target_resource_filter: The target_resource_filter of this CreateCostAnomalyMonitorDetails.
        :type: oci.budget.models.TargetResourceFilter
        """
        self._target_resource_filter = target_resource_filter

    @property
    def cost_alert_subscription_map(self):
        """
        Gets the cost_alert_subscription_map of this CreateCostAnomalyMonitorDetails.

        :return: The cost_alert_subscription_map of this CreateCostAnomalyMonitorDetails.
        :rtype: oci.budget.models.CostAlertSubscriptionMap
        """
        return self._cost_alert_subscription_map

    @cost_alert_subscription_map.setter
    def cost_alert_subscription_map(self, cost_alert_subscription_map):
        """
        Sets the cost_alert_subscription_map of this CreateCostAnomalyMonitorDetails.

        :param cost_alert_subscription_map: The cost_alert_subscription_map of this CreateCostAnomalyMonitorDetails.
        :type: oci.budget.models.CostAlertSubscriptionMap
        """
        self._cost_alert_subscription_map = cost_alert_subscription_map

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCostAnomalyMonitorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateCostAnomalyMonitorDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCostAnomalyMonitorDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateCostAnomalyMonitorDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCostAnomalyMonitorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateCostAnomalyMonitorDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCostAnomalyMonitorDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateCostAnomalyMonitorDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
