# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateOccmDemandSignalDetails(object):
    """
    Details about different fields that can be used to update the demand signal.
    """

    #: A constant which can be used with the lifecycle_details property of a UpdateOccmDemandSignalDetails.
    #: This constant has a value of "SUBMITTED"
    LIFECYCLE_DETAILS_SUBMITTED = "SUBMITTED"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateOccmDemandSignalDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateOccmDemandSignalDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateOccmDemandSignalDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateOccmDemandSignalDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param description:
            The value to assign to the description property of this UpdateOccmDemandSignalDetails.
        :type description: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this UpdateOccmDemandSignalDetails.
            Allowed values for this property are: "SUBMITTED"
        :type lifecycle_details: str

        """
        self.swagger_types = {
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'description': 'str',
            'lifecycle_details': 'str'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'description': 'description',
            'lifecycle_details': 'lifecycleDetails'
        }
        self._display_name = None
        self._freeform_tags = None
        self._defined_tags = None
        self._description = None
        self._lifecycle_details = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateOccmDemandSignalDetails.
        Use this field to update the display name of the demand signal


        :return: The display_name of this UpdateOccmDemandSignalDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateOccmDemandSignalDetails.
        Use this field to update the display name of the demand signal


        :param display_name: The display_name of this UpdateOccmDemandSignalDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateOccmDemandSignalDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateOccmDemandSignalDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateOccmDemandSignalDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateOccmDemandSignalDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateOccmDemandSignalDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateOccmDemandSignalDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateOccmDemandSignalDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateOccmDemandSignalDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def description(self):
        """
        Gets the description of this UpdateOccmDemandSignalDetails.
        Use this field to update the description of the demand signal.


        :return: The description of this UpdateOccmDemandSignalDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateOccmDemandSignalDetails.
        Use this field to update the description of the demand signal.


        :param description: The description of this UpdateOccmDemandSignalDetails.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this UpdateOccmDemandSignalDetails.
        The subset of demand signal states available for updating the demand signal.

        Allowed values for this property are: "SUBMITTED"


        :return: The lifecycle_details of this UpdateOccmDemandSignalDetails.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this UpdateOccmDemandSignalDetails.
        The subset of demand signal states available for updating the demand signal.


        :param lifecycle_details: The lifecycle_details of this UpdateOccmDemandSignalDetails.
        :type: str
        """
        allowed_values = ["SUBMITTED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_details, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_details`, must be None or one of {allowed_values}"
            )
        self._lifecycle_details = lifecycle_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
