# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180222


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CredentialRotationStatus(object):
    """
    Information regarding cluster's credential rotation.
    """

    #: A constant which can be used with the status property of a CredentialRotationStatus.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a CredentialRotationStatus.
    #: This constant has a value of "WAITING"
    STATUS_WAITING = "WAITING"

    #: A constant which can be used with the status property of a CredentialRotationStatus.
    #: This constant has a value of "COMPLETED"
    STATUS_COMPLETED = "COMPLETED"

    #: A constant which can be used with the status_details property of a CredentialRotationStatus.
    #: This constant has a value of "ISSUING_NEW_CREDENTIALS"
    STATUS_DETAILS_ISSUING_NEW_CREDENTIALS = "ISSUING_NEW_CREDENTIALS"

    #: A constant which can be used with the status_details property of a CredentialRotationStatus.
    #: This constant has a value of "NEW_CREDENTIALS_ISSUED"
    STATUS_DETAILS_NEW_CREDENTIALS_ISSUED = "NEW_CREDENTIALS_ISSUED"

    #: A constant which can be used with the status_details property of a CredentialRotationStatus.
    #: This constant has a value of "RETIRING_OLD_CREDENTIALS"
    STATUS_DETAILS_RETIRING_OLD_CREDENTIALS = "RETIRING_OLD_CREDENTIALS"

    #: A constant which can be used with the status_details property of a CredentialRotationStatus.
    #: This constant has a value of "COMPLETED"
    STATUS_DETAILS_COMPLETED = "COMPLETED"

    def __init__(self, **kwargs):
        """
        Initializes a new CredentialRotationStatus object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param time_auto_completion_scheduled:
            The value to assign to the time_auto_completion_scheduled property of this CredentialRotationStatus.
        :type time_auto_completion_scheduled: datetime

        :param status:
            The value to assign to the status property of this CredentialRotationStatus.
            Allowed values for this property are: "IN_PROGRESS", "WAITING", "COMPLETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param status_details:
            The value to assign to the status_details property of this CredentialRotationStatus.
            Allowed values for this property are: "ISSUING_NEW_CREDENTIALS", "NEW_CREDENTIALS_ISSUED", "RETIRING_OLD_CREDENTIALS", "COMPLETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status_details: str

        """
        self.swagger_types = {
            'time_auto_completion_scheduled': 'datetime',
            'status': 'str',
            'status_details': 'str'
        }
        self.attribute_map = {
            'time_auto_completion_scheduled': 'timeAutoCompletionScheduled',
            'status': 'status',
            'status_details': 'statusDetails'
        }
        self._time_auto_completion_scheduled = None
        self._status = None
        self._status_details = None

    @property
    def time_auto_completion_scheduled(self):
        """
        Gets the time_auto_completion_scheduled of this CredentialRotationStatus.
        The time by which retirement of old credentials should start.


        :return: The time_auto_completion_scheduled of this CredentialRotationStatus.
        :rtype: datetime
        """
        return self._time_auto_completion_scheduled

    @time_auto_completion_scheduled.setter
    def time_auto_completion_scheduled(self, time_auto_completion_scheduled):
        """
        Sets the time_auto_completion_scheduled of this CredentialRotationStatus.
        The time by which retirement of old credentials should start.


        :param time_auto_completion_scheduled: The time_auto_completion_scheduled of this CredentialRotationStatus.
        :type: datetime
        """
        self._time_auto_completion_scheduled = time_auto_completion_scheduled

    @property
    def status(self):
        """
        **[Required]** Gets the status of this CredentialRotationStatus.
        Credential rotation status of a kubernetes cluster
        IN_PROGRESS: Issuing new credentials to kubernetes cluster control plane and worker nodes or retiring old credentials from kubernetes cluster control plane and worker nodes.
        WAITING: Waiting for customer to invoke the complete rotation action or the automcatic complete rotation action.
        COMPLETED: New credentials are functional on kuberentes cluster.

        Allowed values for this property are: "IN_PROGRESS", "WAITING", "COMPLETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this CredentialRotationStatus.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this CredentialRotationStatus.
        Credential rotation status of a kubernetes cluster
        IN_PROGRESS: Issuing new credentials to kubernetes cluster control plane and worker nodes or retiring old credentials from kubernetes cluster control plane and worker nodes.
        WAITING: Waiting for customer to invoke the complete rotation action or the automcatic complete rotation action.
        COMPLETED: New credentials are functional on kuberentes cluster.


        :param status: The status of this CredentialRotationStatus.
        :type: str
        """
        allowed_values = ["IN_PROGRESS", "WAITING", "COMPLETED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def status_details(self):
        """
        **[Required]** Gets the status_details of this CredentialRotationStatus.
        Details of a kuberenetes cluster credential rotation status:
        ISSUING_NEW_CREDENTIALS: Credential rotation is in progress. Starting to issue new credentials to kubernetes cluster control plane and worker nodes.
        NEW_CREDENTIALS_ISSUED: New credentials are added. At this stage cluster has both old and new credentials and is awaiting old credentials retirement.
        RETIRING_OLD_CREDENTIALS: Retirement of old credentials is in progress. Starting to remove old credentials from kubernetes cluster control plane and worker nodes.
        COMPLETED: Credential rotation is complete. Old credentials are retired.

        Allowed values for this property are: "ISSUING_NEW_CREDENTIALS", "NEW_CREDENTIALS_ISSUED", "RETIRING_OLD_CREDENTIALS", "COMPLETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status_details of this CredentialRotationStatus.
        :rtype: str
        """
        return self._status_details

    @status_details.setter
    def status_details(self, status_details):
        """
        Sets the status_details of this CredentialRotationStatus.
        Details of a kuberenetes cluster credential rotation status:
        ISSUING_NEW_CREDENTIALS: Credential rotation is in progress. Starting to issue new credentials to kubernetes cluster control plane and worker nodes.
        NEW_CREDENTIALS_ISSUED: New credentials are added. At this stage cluster has both old and new credentials and is awaiting old credentials retirement.
        RETIRING_OLD_CREDENTIALS: Retirement of old credentials is in progress. Starting to remove old credentials from kubernetes cluster control plane and worker nodes.
        COMPLETED: Credential rotation is complete. Old credentials are retired.


        :param status_details: The status_details of this CredentialRotationStatus.
        :type: str
        """
        allowed_values = ["ISSUING_NEW_CREDENTIALS", "NEW_CREDENTIALS_ISSUED", "RETIRING_OLD_CREDENTIALS", "COMPLETED"]
        if not value_allowed_none_or_none_sentinel(status_details, allowed_values):
            status_details = 'UNKNOWN_ENUM_VALUE'
        self._status_details = status_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
