# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CapacityConfig(object):
    """
    Specifies the capacity configs that the Dedicated Virtual Machine Host (DVMH) Shape could support.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CapacityConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param capacity_config_name:
            The value to assign to the capacity_config_name property of this CapacityConfig.
        :type capacity_config_name: str

        :param supported_capabilities:
            The value to assign to the supported_capabilities property of this CapacityConfig.
        :type supported_capabilities: oci.core.models.SupportedCapabilities

        :param is_default:
            The value to assign to the is_default property of this CapacityConfig.
        :type is_default: bool

        :param capacity_bins:
            The value to assign to the capacity_bins property of this CapacityConfig.
        :type capacity_bins: list[oci.core.models.CapacityBinPreview]

        """
        self.swagger_types = {
            'capacity_config_name': 'str',
            'supported_capabilities': 'SupportedCapabilities',
            'is_default': 'bool',
            'capacity_bins': 'list[CapacityBinPreview]'
        }
        self.attribute_map = {
            'capacity_config_name': 'capacityConfigName',
            'supported_capabilities': 'supportedCapabilities',
            'is_default': 'isDefault',
            'capacity_bins': 'capacityBins'
        }
        self._capacity_config_name = None
        self._supported_capabilities = None
        self._is_default = None
        self._capacity_bins = None

    @property
    def capacity_config_name(self):
        """
        Gets the capacity_config_name of this CapacityConfig.
        The name of each capacity config.


        :return: The capacity_config_name of this CapacityConfig.
        :rtype: str
        """
        return self._capacity_config_name

    @capacity_config_name.setter
    def capacity_config_name(self, capacity_config_name):
        """
        Sets the capacity_config_name of this CapacityConfig.
        The name of each capacity config.


        :param capacity_config_name: The capacity_config_name of this CapacityConfig.
        :type: str
        """
        self._capacity_config_name = capacity_config_name

    @property
    def supported_capabilities(self):
        """
        Gets the supported_capabilities of this CapacityConfig.

        :return: The supported_capabilities of this CapacityConfig.
        :rtype: oci.core.models.SupportedCapabilities
        """
        return self._supported_capabilities

    @supported_capabilities.setter
    def supported_capabilities(self, supported_capabilities):
        """
        Sets the supported_capabilities of this CapacityConfig.

        :param supported_capabilities: The supported_capabilities of this CapacityConfig.
        :type: oci.core.models.SupportedCapabilities
        """
        self._supported_capabilities = supported_capabilities

    @property
    def is_default(self):
        """
        Gets the is_default of this CapacityConfig.
        Whether this capacity config is the default config.


        :return: The is_default of this CapacityConfig.
        :rtype: bool
        """
        return self._is_default

    @is_default.setter
    def is_default(self, is_default):
        """
        Sets the is_default of this CapacityConfig.
        Whether this capacity config is the default config.


        :param is_default: The is_default of this CapacityConfig.
        :type: bool
        """
        self._is_default = is_default

    @property
    def capacity_bins(self):
        """
        Gets the capacity_bins of this CapacityConfig.
        A list of total CPU and memory per capacity bucket.


        :return: The capacity_bins of this CapacityConfig.
        :rtype: list[oci.core.models.CapacityBinPreview]
        """
        return self._capacity_bins

    @capacity_bins.setter
    def capacity_bins(self, capacity_bins):
        """
        Sets the capacity_bins of this CapacityConfig.
        A list of total CPU and memory per capacity bucket.


        :param capacity_bins: The capacity_bins of this CapacityConfig.
        :type: list[oci.core.models.CapacityBinPreview]
        """
        self._capacity_bins = capacity_bins

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
