# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateComputeCapacityTopologyDetails(object):
    """
    The details for creating a new compute capacity topology.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateComputeCapacityTopologyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateComputeCapacityTopologyDetails.
        :type availability_domain: str

        :param capacity_source:
            The value to assign to the capacity_source property of this CreateComputeCapacityTopologyDetails.
        :type capacity_source: oci.core.models.CreateCapacitySourceDetails

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateComputeCapacityTopologyDetails.
        :type compartment_id: str

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateComputeCapacityTopologyDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this CreateComputeCapacityTopologyDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateComputeCapacityTopologyDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'availability_domain': 'str',
            'capacity_source': 'CreateCapacitySourceDetails',
            'compartment_id': 'str',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)'
        }
        self.attribute_map = {
            'availability_domain': 'availabilityDomain',
            'capacity_source': 'capacitySource',
            'compartment_id': 'compartmentId',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags'
        }
        self._availability_domain = None
        self._capacity_source = None
        self._compartment_id = None
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None

    @property
    def availability_domain(self):
        """
        **[Required]** Gets the availability_domain of this CreateComputeCapacityTopologyDetails.
        The availability domain of this compute capacity topology.

        Example: `Uocm:US-CHICAGO-1-AD-2`


        :return: The availability_domain of this CreateComputeCapacityTopologyDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateComputeCapacityTopologyDetails.
        The availability domain of this compute capacity topology.

        Example: `Uocm:US-CHICAGO-1-AD-2`


        :param availability_domain: The availability_domain of this CreateComputeCapacityTopologyDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def capacity_source(self):
        """
        **[Required]** Gets the capacity_source of this CreateComputeCapacityTopologyDetails.

        :return: The capacity_source of this CreateComputeCapacityTopologyDetails.
        :rtype: oci.core.models.CreateCapacitySourceDetails
        """
        return self._capacity_source

    @capacity_source.setter
    def capacity_source(self, capacity_source):
        """
        Sets the capacity_source of this CreateComputeCapacityTopologyDetails.

        :param capacity_source: The capacity_source of this CreateComputeCapacityTopologyDetails.
        :type: oci.core.models.CreateCapacitySourceDetails
        """
        self._capacity_source = capacity_source

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateComputeCapacityTopologyDetails.
        The `OCID`__ of the compartment that contains this compute capacity topology.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateComputeCapacityTopologyDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateComputeCapacityTopologyDetails.
        The `OCID`__ of the compartment that contains this compute capacity topology.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateComputeCapacityTopologyDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateComputeCapacityTopologyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateComputeCapacityTopologyDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateComputeCapacityTopologyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a
        namespace. For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateComputeCapacityTopologyDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateComputeCapacityTopologyDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :return: The display_name of this CreateComputeCapacityTopologyDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateComputeCapacityTopologyDetails.
        A user-friendly name. Does not have to be unique, and it's changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this CreateComputeCapacityTopologyDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateComputeCapacityTopologyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateComputeCapacityTopologyDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateComputeCapacityTopologyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no
        predefined name, type, or namespace. For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateComputeCapacityTopologyDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
