# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IpInventoryCidrUtilizationSummary(object):
    """
    The CIDR utilization details of a subnet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IpInventoryCidrUtilizationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param cidr:
            The value to assign to the cidr property of this IpInventoryCidrUtilizationSummary.
        :type cidr: str

        :param utilization:
            The value to assign to the utilization property of this IpInventoryCidrUtilizationSummary.
        :type utilization: float

        :param address_type:
            The value to assign to the address_type property of this IpInventoryCidrUtilizationSummary.
        :type address_type: str

        """
        self.swagger_types = {
            'cidr': 'str',
            'utilization': 'float',
            'address_type': 'str'
        }
        self.attribute_map = {
            'cidr': 'cidr',
            'utilization': 'utilization',
            'address_type': 'addressType'
        }
        self._cidr = None
        self._utilization = None
        self._address_type = None

    @property
    def cidr(self):
        """
        Gets the cidr of this IpInventoryCidrUtilizationSummary.
        The CIDR range of a subnet.


        :return: The cidr of this IpInventoryCidrUtilizationSummary.
        :rtype: str
        """
        return self._cidr

    @cidr.setter
    def cidr(self, cidr):
        """
        Sets the cidr of this IpInventoryCidrUtilizationSummary.
        The CIDR range of a subnet.


        :param cidr: The cidr of this IpInventoryCidrUtilizationSummary.
        :type: str
        """
        self._cidr = cidr

    @property
    def utilization(self):
        """
        Gets the utilization of this IpInventoryCidrUtilizationSummary.
        The CIDR utilisation of a subnet.


        :return: The utilization of this IpInventoryCidrUtilizationSummary.
        :rtype: float
        """
        return self._utilization

    @utilization.setter
    def utilization(self, utilization):
        """
        Sets the utilization of this IpInventoryCidrUtilizationSummary.
        The CIDR utilisation of a subnet.


        :param utilization: The utilization of this IpInventoryCidrUtilizationSummary.
        :type: float
        """
        self._utilization = utilization

    @property
    def address_type(self):
        """
        Gets the address_type of this IpInventoryCidrUtilizationSummary.
        Address type of the CIDR within a subnet.


        :return: The address_type of this IpInventoryCidrUtilizationSummary.
        :rtype: str
        """
        return self._address_type

    @address_type.setter
    def address_type(self, address_type):
        """
        Sets the address_type of this IpInventoryCidrUtilizationSummary.
        Address type of the CIDR within a subnet.


        :param address_type: The address_type of this IpInventoryCidrUtilizationSummary.
        :type: str
        """
        self._address_type = address_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
