# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateSensitiveTypesExportDetails(object):
    """
    Details to create a new sensitive types export. To specify some sensitive types for export, use
    sensitiveTypeIdsForExport attribute. But if you want to include all sensitive types, you can set
    isIncludeAllSensitiveTypes attributes to true. In the latter case, you do not need to list all
    sensitive types.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateSensitiveTypesExportDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateSensitiveTypesExportDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this CreateSensitiveTypesExportDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateSensitiveTypesExportDetails.
        :type compartment_id: str

        :param sensitive_type_ids_for_export:
            The value to assign to the sensitive_type_ids_for_export property of this CreateSensitiveTypesExportDetails.
        :type sensitive_type_ids_for_export: list[str]

        :param is_include_all_sensitive_types:
            The value to assign to the is_include_all_sensitive_types property of this CreateSensitiveTypesExportDetails.
        :type is_include_all_sensitive_types: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateSensitiveTypesExportDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateSensitiveTypesExportDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'sensitive_type_ids_for_export': 'list[str]',
            'is_include_all_sensitive_types': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'sensitive_type_ids_for_export': 'sensitiveTypeIdsForExport',
            'is_include_all_sensitive_types': 'isIncludeAllSensitiveTypes',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._sensitive_type_ids_for_export = None
        self._is_include_all_sensitive_types = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this CreateSensitiveTypesExportDetails.
        The display name of the sensitive types export. The name does not have to be unique, and it's changeable.


        :return: The display_name of this CreateSensitiveTypesExportDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateSensitiveTypesExportDetails.
        The display name of the sensitive types export. The name does not have to be unique, and it's changeable.


        :param display_name: The display_name of this CreateSensitiveTypesExportDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this CreateSensitiveTypesExportDetails.
        The description of the sensitive types export.


        :return: The description of this CreateSensitiveTypesExportDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateSensitiveTypesExportDetails.
        The description of the sensitive types export.


        :param description: The description of this CreateSensitiveTypesExportDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateSensitiveTypesExportDetails.
        The OCID of the compartment where the sensitive types export should be created.


        :return: The compartment_id of this CreateSensitiveTypesExportDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateSensitiveTypesExportDetails.
        The OCID of the compartment where the sensitive types export should be created.


        :param compartment_id: The compartment_id of this CreateSensitiveTypesExportDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def sensitive_type_ids_for_export(self):
        """
        Gets the sensitive_type_ids_for_export of this CreateSensitiveTypesExportDetails.
        The OCIDs of the sensitive types used to create sensitive types export.


        :return: The sensitive_type_ids_for_export of this CreateSensitiveTypesExportDetails.
        :rtype: list[str]
        """
        return self._sensitive_type_ids_for_export

    @sensitive_type_ids_for_export.setter
    def sensitive_type_ids_for_export(self, sensitive_type_ids_for_export):
        """
        Sets the sensitive_type_ids_for_export of this CreateSensitiveTypesExportDetails.
        The OCIDs of the sensitive types used to create sensitive types export.


        :param sensitive_type_ids_for_export: The sensitive_type_ids_for_export of this CreateSensitiveTypesExportDetails.
        :type: list[str]
        """
        self._sensitive_type_ids_for_export = sensitive_type_ids_for_export

    @property
    def is_include_all_sensitive_types(self):
        """
        Gets the is_include_all_sensitive_types of this CreateSensitiveTypesExportDetails.
        Indicates if all the existing user-defined sensitive types are used for export. If it's set to true, the
        sensitiveTypeIdsForExport attribute is ignored and all user-defined sensitive types are used.


        :return: The is_include_all_sensitive_types of this CreateSensitiveTypesExportDetails.
        :rtype: bool
        """
        return self._is_include_all_sensitive_types

    @is_include_all_sensitive_types.setter
    def is_include_all_sensitive_types(self, is_include_all_sensitive_types):
        """
        Sets the is_include_all_sensitive_types of this CreateSensitiveTypesExportDetails.
        Indicates if all the existing user-defined sensitive types are used for export. If it's set to true, the
        sensitiveTypeIdsForExport attribute is ignored and all user-defined sensitive types are used.


        :param is_include_all_sensitive_types: The is_include_all_sensitive_types of this CreateSensitiveTypesExportDetails.
        :type: bool
        """
        self._is_include_all_sensitive_types = is_include_all_sensitive_types

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateSensitiveTypesExportDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CreateSensitiveTypesExportDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateSensitiveTypesExportDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CreateSensitiveTypesExportDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateSensitiveTypesExportDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CreateSensitiveTypesExportDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateSensitiveTypesExportDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CreateSensitiveTypesExportDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
