# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SecurityAssessmentTemplateBaselineComparison(object):
    """
    Provides a list of the differences in a comparison of the security assessment with the template baseline value.
    """

    #: A constant which can be used with the lifecycle_state property of a SecurityAssessmentTemplateBaselineComparison.
    #: This constant has a value of "IN_PROGRESS"
    LIFECYCLE_STATE_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the lifecycle_state property of a SecurityAssessmentTemplateBaselineComparison.
    #: This constant has a value of "SUCCEEDED"
    LIFECYCLE_STATE_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the lifecycle_state property of a SecurityAssessmentTemplateBaselineComparison.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a SecurityAssessmentTemplateBaselineComparison.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a SecurityAssessmentTemplateBaselineComparison.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    def __init__(self, **kwargs):
        """
        Initializes a new SecurityAssessmentTemplateBaselineComparison object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SecurityAssessmentTemplateBaselineComparison.
        :type id: str

        :param template_baseline_id:
            The value to assign to the template_baseline_id property of this SecurityAssessmentTemplateBaselineComparison.
        :type template_baseline_id: str

        :param template_baseline_name:
            The value to assign to the template_baseline_name property of this SecurityAssessmentTemplateBaselineComparison.
        :type template_baseline_name: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SecurityAssessmentTemplateBaselineComparison.
            Allowed values for this property are: "IN_PROGRESS", "SUCCEEDED", "FAILED", "DELETED", "DELETING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this SecurityAssessmentTemplateBaselineComparison.
        :type time_created: datetime

        :param auditing:
            The value to assign to the auditing property of this SecurityAssessmentTemplateBaselineComparison.
        :type auditing: list[oci.data_safe.models.TemplateBaselineDiffs]

        :param authorization_control:
            The value to assign to the authorization_control property of this SecurityAssessmentTemplateBaselineComparison.
        :type authorization_control: list[oci.data_safe.models.TemplateBaselineDiffs]

        :param data_encryption:
            The value to assign to the data_encryption property of this SecurityAssessmentTemplateBaselineComparison.
        :type data_encryption: list[oci.data_safe.models.TemplateBaselineDiffs]

        :param db_configuration:
            The value to assign to the db_configuration property of this SecurityAssessmentTemplateBaselineComparison.
        :type db_configuration: list[oci.data_safe.models.TemplateBaselineDiffs]

        :param fine_grained_access_control:
            The value to assign to the fine_grained_access_control property of this SecurityAssessmentTemplateBaselineComparison.
        :type fine_grained_access_control: list[oci.data_safe.models.TemplateBaselineDiffs]

        :param privileges_and_roles:
            The value to assign to the privileges_and_roles property of this SecurityAssessmentTemplateBaselineComparison.
        :type privileges_and_roles: list[oci.data_safe.models.TemplateBaselineDiffs]

        :param user_accounts:
            The value to assign to the user_accounts property of this SecurityAssessmentTemplateBaselineComparison.
        :type user_accounts: list[oci.data_safe.models.TemplateBaselineDiffs]

        """
        self.swagger_types = {
            'id': 'str',
            'template_baseline_id': 'str',
            'template_baseline_name': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'auditing': 'list[TemplateBaselineDiffs]',
            'authorization_control': 'list[TemplateBaselineDiffs]',
            'data_encryption': 'list[TemplateBaselineDiffs]',
            'db_configuration': 'list[TemplateBaselineDiffs]',
            'fine_grained_access_control': 'list[TemplateBaselineDiffs]',
            'privileges_and_roles': 'list[TemplateBaselineDiffs]',
            'user_accounts': 'list[TemplateBaselineDiffs]'
        }
        self.attribute_map = {
            'id': 'id',
            'template_baseline_id': 'templateBaselineId',
            'template_baseline_name': 'templateBaselineName',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'auditing': 'auditing',
            'authorization_control': 'authorizationControl',
            'data_encryption': 'dataEncryption',
            'db_configuration': 'dbConfiguration',
            'fine_grained_access_control': 'fineGrainedAccessControl',
            'privileges_and_roles': 'privilegesAndRoles',
            'user_accounts': 'userAccounts'
        }
        self._id = None
        self._template_baseline_id = None
        self._template_baseline_name = None
        self._lifecycle_state = None
        self._time_created = None
        self._auditing = None
        self._authorization_control = None
        self._data_encryption = None
        self._db_configuration = None
        self._fine_grained_access_control = None
        self._privileges_and_roles = None
        self._user_accounts = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SecurityAssessmentTemplateBaselineComparison.
        The OCID of the security assessment that is being compared with a template baseline security assessment.


        :return: The id of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SecurityAssessmentTemplateBaselineComparison.
        The OCID of the security assessment that is being compared with a template baseline security assessment.


        :param id: The id of this SecurityAssessmentTemplateBaselineComparison.
        :type: str
        """
        self._id = id

    @property
    def template_baseline_id(self):
        """
        **[Required]** Gets the template_baseline_id of this SecurityAssessmentTemplateBaselineComparison.
        The OCID of the security assessment that is set as a template baseline.


        :return: The template_baseline_id of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: str
        """
        return self._template_baseline_id

    @template_baseline_id.setter
    def template_baseline_id(self, template_baseline_id):
        """
        Sets the template_baseline_id of this SecurityAssessmentTemplateBaselineComparison.
        The OCID of the security assessment that is set as a template baseline.


        :param template_baseline_id: The template_baseline_id of this SecurityAssessmentTemplateBaselineComparison.
        :type: str
        """
        self._template_baseline_id = template_baseline_id

    @property
    def template_baseline_name(self):
        """
        Gets the template_baseline_name of this SecurityAssessmentTemplateBaselineComparison.
        The display name of the security assessment that is set as a template baseline.


        :return: The template_baseline_name of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: str
        """
        return self._template_baseline_name

    @template_baseline_name.setter
    def template_baseline_name(self, template_baseline_name):
        """
        Sets the template_baseline_name of this SecurityAssessmentTemplateBaselineComparison.
        The display name of the security assessment that is set as a template baseline.


        :param template_baseline_name: The template_baseline_name of this SecurityAssessmentTemplateBaselineComparison.
        :type: str
        """
        self._template_baseline_name = template_baseline_name

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SecurityAssessmentTemplateBaselineComparison.
        The current state of the security assessment comparison.

        Allowed values for this property are: "IN_PROGRESS", "SUCCEEDED", "FAILED", "DELETED", "DELETING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SecurityAssessmentTemplateBaselineComparison.
        The current state of the security assessment comparison.


        :param lifecycle_state: The lifecycle_state of this SecurityAssessmentTemplateBaselineComparison.
        :type: str
        """
        allowed_values = ["IN_PROGRESS", "SUCCEEDED", "FAILED", "DELETED", "DELETING"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this SecurityAssessmentTemplateBaselineComparison.
        The date and time when the security assessment comparison was created. Conforms to the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this SecurityAssessmentTemplateBaselineComparison.
        The date and time when the security assessment comparison was created. Conforms to the format defined by `RFC3339`__.

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this SecurityAssessmentTemplateBaselineComparison.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def auditing(self):
        """
        Gets the auditing of this SecurityAssessmentTemplateBaselineComparison.
        A comparison between findings belonging to Auditing category.


        :return: The auditing of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        return self._auditing

    @auditing.setter
    def auditing(self, auditing):
        """
        Sets the auditing of this SecurityAssessmentTemplateBaselineComparison.
        A comparison between findings belonging to Auditing category.


        :param auditing: The auditing of this SecurityAssessmentTemplateBaselineComparison.
        :type: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        self._auditing = auditing

    @property
    def authorization_control(self):
        """
        Gets the authorization_control of this SecurityAssessmentTemplateBaselineComparison.
        A comparison between findings belonging to Authorization Control category.


        :return: The authorization_control of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        return self._authorization_control

    @authorization_control.setter
    def authorization_control(self, authorization_control):
        """
        Sets the authorization_control of this SecurityAssessmentTemplateBaselineComparison.
        A comparison between findings belonging to Authorization Control category.


        :param authorization_control: The authorization_control of this SecurityAssessmentTemplateBaselineComparison.
        :type: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        self._authorization_control = authorization_control

    @property
    def data_encryption(self):
        """
        Gets the data_encryption of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Data Encryption category.


        :return: The data_encryption of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        return self._data_encryption

    @data_encryption.setter
    def data_encryption(self, data_encryption):
        """
        Sets the data_encryption of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Data Encryption category.


        :param data_encryption: The data_encryption of this SecurityAssessmentTemplateBaselineComparison.
        :type: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        self._data_encryption = data_encryption

    @property
    def db_configuration(self):
        """
        Gets the db_configuration of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Database Configuration category.


        :return: The db_configuration of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        return self._db_configuration

    @db_configuration.setter
    def db_configuration(self, db_configuration):
        """
        Sets the db_configuration of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Database Configuration category.


        :param db_configuration: The db_configuration of this SecurityAssessmentTemplateBaselineComparison.
        :type: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        self._db_configuration = db_configuration

    @property
    def fine_grained_access_control(self):
        """
        Gets the fine_grained_access_control of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Fine-Grained Access Control category.


        :return: The fine_grained_access_control of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        return self._fine_grained_access_control

    @fine_grained_access_control.setter
    def fine_grained_access_control(self, fine_grained_access_control):
        """
        Sets the fine_grained_access_control of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Fine-Grained Access Control category.


        :param fine_grained_access_control: The fine_grained_access_control of this SecurityAssessmentTemplateBaselineComparison.
        :type: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        self._fine_grained_access_control = fine_grained_access_control

    @property
    def privileges_and_roles(self):
        """
        Gets the privileges_and_roles of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Privileges and Roles category.


        :return: The privileges_and_roles of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        return self._privileges_and_roles

    @privileges_and_roles.setter
    def privileges_and_roles(self, privileges_and_roles):
        """
        Sets the privileges_and_roles of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to Privileges and Roles category.


        :param privileges_and_roles: The privileges_and_roles of this SecurityAssessmentTemplateBaselineComparison.
        :type: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        self._privileges_and_roles = privileges_and_roles

    @property
    def user_accounts(self):
        """
        Gets the user_accounts of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to User Accounts category.


        :return: The user_accounts of this SecurityAssessmentTemplateBaselineComparison.
        :rtype: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        return self._user_accounts

    @user_accounts.setter
    def user_accounts(self, user_accounts):
        """
        Sets the user_accounts of this SecurityAssessmentTemplateBaselineComparison.
        Comparison between findings belonging to User Accounts category.


        :param user_accounts: The user_accounts of this SecurityAssessmentTemplateBaselineComparison.
        :type: list[oci.data_safe.models.TemplateBaselineDiffs]
        """
        self._user_accounts = user_accounts

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
