# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetDatabaseGroupSummary(object):
    """
    Summary of the target database group used in list operations. Contains essential information without matching criteria.
    """

    #: A constant which can be used with the lifecycle_state property of a TargetDatabaseGroupSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a TargetDatabaseGroupSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a TargetDatabaseGroupSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a TargetDatabaseGroupSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a TargetDatabaseGroupSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a TargetDatabaseGroupSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a TargetDatabaseGroupSummary.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    def __init__(self, **kwargs):
        """
        Initializes a new TargetDatabaseGroupSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this TargetDatabaseGroupSummary.
        :type compartment_id: str

        :param id:
            The value to assign to the id property of this TargetDatabaseGroupSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this TargetDatabaseGroupSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this TargetDatabaseGroupSummary.
        :type description: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this TargetDatabaseGroupSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this TargetDatabaseGroupSummary.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this TargetDatabaseGroupSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this TargetDatabaseGroupSummary.
        :type time_updated: datetime

        :param membership_update_time:
            The value to assign to the membership_update_time property of this TargetDatabaseGroupSummary.
        :type membership_update_time: datetime

        :param membership_count:
            The value to assign to the membership_count property of this TargetDatabaseGroupSummary.
        :type membership_count: int

        :param freeform_tags:
            The value to assign to the freeform_tags property of this TargetDatabaseGroupSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this TargetDatabaseGroupSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this TargetDatabaseGroupSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'membership_update_time': 'datetime',
            'membership_count': 'int',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'membership_update_time': 'membershipUpdateTime',
            'membership_count': 'membershipCount',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._compartment_id = None
        self._id = None
        self._display_name = None
        self._description = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._membership_update_time = None
        self._membership_count = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this TargetDatabaseGroupSummary.
        The OCID for the compartment containing the target database group.


        :return: The compartment_id of this TargetDatabaseGroupSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this TargetDatabaseGroupSummary.
        The OCID for the compartment containing the target database group.


        :param compartment_id: The compartment_id of this TargetDatabaseGroupSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def id(self):
        """
        **[Required]** Gets the id of this TargetDatabaseGroupSummary.
        The OCID of the specified target database group.


        :return: The id of this TargetDatabaseGroupSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TargetDatabaseGroupSummary.
        The OCID of the specified target database group.


        :param id: The id of this TargetDatabaseGroupSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this TargetDatabaseGroupSummary.
        The name of the target database group.


        :return: The display_name of this TargetDatabaseGroupSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this TargetDatabaseGroupSummary.
        The name of the target database group.


        :param display_name: The display_name of this TargetDatabaseGroupSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this TargetDatabaseGroupSummary.
        Description of the target database group.


        :return: The description of this TargetDatabaseGroupSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this TargetDatabaseGroupSummary.
        Description of the target database group.


        :param description: The description of this TargetDatabaseGroupSummary.
        :type: str
        """
        self._description = description

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this TargetDatabaseGroupSummary.
        The lifecycle status of the target database group.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this TargetDatabaseGroupSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this TargetDatabaseGroupSummary.
        The lifecycle status of the target database group.


        :param lifecycle_state: The lifecycle_state of this TargetDatabaseGroupSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", "NEEDS_ATTENTION"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this TargetDatabaseGroupSummary.
        Details for the lifecycle status of the target database group.


        :return: The lifecycle_details of this TargetDatabaseGroupSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this TargetDatabaseGroupSummary.
        Details for the lifecycle status of the target database group.


        :param lifecycle_details: The lifecycle_details of this TargetDatabaseGroupSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this TargetDatabaseGroupSummary.
        Time when the target database group was created.


        :return: The time_created of this TargetDatabaseGroupSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this TargetDatabaseGroupSummary.
        Time when the target database group was created.


        :param time_created: The time_created of this TargetDatabaseGroupSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this TargetDatabaseGroupSummary.
        Time when the target database group was last updated.


        :return: The time_updated of this TargetDatabaseGroupSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this TargetDatabaseGroupSummary.
        Time when the target database group was last updated.


        :param time_updated: The time_updated of this TargetDatabaseGroupSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def membership_update_time(self):
        """
        **[Required]** Gets the membership_update_time of this TargetDatabaseGroupSummary.
        Time when the members of the target database group were last changed, i.e. the list was refreshed, a target database was added or removed.


        :return: The membership_update_time of this TargetDatabaseGroupSummary.
        :rtype: datetime
        """
        return self._membership_update_time

    @membership_update_time.setter
    def membership_update_time(self, membership_update_time):
        """
        Sets the membership_update_time of this TargetDatabaseGroupSummary.
        Time when the members of the target database group were last changed, i.e. the list was refreshed, a target database was added or removed.


        :param membership_update_time: The membership_update_time of this TargetDatabaseGroupSummary.
        :type: datetime
        """
        self._membership_update_time = membership_update_time

    @property
    def membership_count(self):
        """
        **[Required]** Gets the membership_count of this TargetDatabaseGroupSummary.
        The number of target databases in the specified target database group.


        :return: The membership_count of this TargetDatabaseGroupSummary.
        :rtype: int
        """
        return self._membership_count

    @membership_count.setter
    def membership_count(self, membership_count):
        """
        Sets the membership_count of this TargetDatabaseGroupSummary.
        The number of target databases in the specified target database group.


        :param membership_count: The membership_count of this TargetDatabaseGroupSummary.
        :type: int
        """
        self._membership_count = membership_count

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this TargetDatabaseGroupSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this TargetDatabaseGroupSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this TargetDatabaseGroupSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this TargetDatabaseGroupSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this TargetDatabaseGroupSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this TargetDatabaseGroupSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this TargetDatabaseGroupSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this TargetDatabaseGroupSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this TargetDatabaseGroupSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this TargetDatabaseGroupSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this TargetDatabaseGroupSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this TargetDatabaseGroupSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
