# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .job_network_configuration import JobNetworkConfiguration
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JobDefaultNetworkConfiguration(JobNetworkConfiguration):
    """
    The job default network configuration details
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JobDefaultNetworkConfiguration object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.JobDefaultNetworkConfiguration.job_network_type` attribute
        of this class is ``DEFAULT_NETWORK`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param job_network_type:
            The value to assign to the job_network_type property of this JobDefaultNetworkConfiguration.
            Allowed values for this property are: "CUSTOM_NETWORK", "DEFAULT_NETWORK"
        :type job_network_type: str

        """
        self.swagger_types = {
            'job_network_type': 'str'
        }
        self.attribute_map = {
            'job_network_type': 'jobNetworkType'
        }
        self._job_network_type = None
        self._job_network_type = 'DEFAULT_NETWORK'

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
