# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .instance_component import InstanceComponent
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageBucketInstanceComponent(InstanceComponent):
    """
    Reference to Object Storage Bucket
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageBucketInstanceComponent object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.ObjectStorageBucketInstanceComponent.type` attribute
        of this class is ``OBJECT_STORAGE_BUCKET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this ObjectStorageBucketInstanceComponent.
            Allowed values for this property are: "DATA_SCIENCE_MODEL_DEPLOYMENT", "OBJECT_STORAGE_BUCKET", "OBJECT_STORAGE_OBJECT", "ML_APPLICATION_INSTANCE_INTERNAL_TRIGGER", "DATA_SCIENCE_SCHEDULE", "GENERIC_OCI_RESOURCE"
        :type type: str

        :param name:
            The value to assign to the name property of this ObjectStorageBucketInstanceComponent.
        :type name: str

        :param component_name:
            The value to assign to the component_name property of this ObjectStorageBucketInstanceComponent.
        :type component_name: str

        :param namespace:
            The value to assign to the namespace property of this ObjectStorageBucketInstanceComponent.
        :type namespace: str

        :param bucket_id:
            The value to assign to the bucket_id property of this ObjectStorageBucketInstanceComponent.
        :type bucket_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'component_name': 'str',
            'namespace': 'str',
            'bucket_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'component_name': 'componentName',
            'namespace': 'namespace',
            'bucket_id': 'bucketId'
        }
        self._type = None
        self._name = None
        self._component_name = None
        self._namespace = None
        self._bucket_id = None
        self._type = 'OBJECT_STORAGE_BUCKET'

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this ObjectStorageBucketInstanceComponent.
        Object Storage namespace


        :return: The namespace of this ObjectStorageBucketInstanceComponent.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ObjectStorageBucketInstanceComponent.
        Object Storage namespace


        :param namespace: The namespace of this ObjectStorageBucketInstanceComponent.
        :type: str
        """
        self._namespace = namespace

    @property
    def bucket_id(self):
        """
        **[Required]** Gets the bucket_id of this ObjectStorageBucketInstanceComponent.
        OCID of Object Storage Bucket


        :return: The bucket_id of this ObjectStorageBucketInstanceComponent.
        :rtype: str
        """
        return self._bucket_id

    @bucket_id.setter
    def bucket_id(self, bucket_id):
        """
        Sets the bucket_id of this ObjectStorageBucketInstanceComponent.
        OCID of Object Storage Bucket


        :param bucket_id: The bucket_id of this ObjectStorageBucketInstanceComponent.
        :type: str
        """
        self._bucket_id = bucket_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
