# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PredictionEndpointDetails(object):
    """
    Prediction endpoint related information.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PredictionEndpointDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param base_prediction_uri:
            The value to assign to the base_prediction_uri property of this PredictionEndpointDetails.
        :type base_prediction_uri: str

        :param prediction_uris:
            The value to assign to the prediction_uris property of this PredictionEndpointDetails.
        :type prediction_uris: list[oci.data_science.models.PredictionUri]

        """
        self.swagger_types = {
            'base_prediction_uri': 'str',
            'prediction_uris': 'list[PredictionUri]'
        }
        self.attribute_map = {
            'base_prediction_uri': 'basePredictionUri',
            'prediction_uris': 'predictionUris'
        }
        self._base_prediction_uri = None
        self._prediction_uris = None

    @property
    def base_prediction_uri(self):
        """
        **[Required]** Gets the base_prediction_uri of this PredictionEndpointDetails.
        Base URI of prediction router.


        :return: The base_prediction_uri of this PredictionEndpointDetails.
        :rtype: str
        """
        return self._base_prediction_uri

    @base_prediction_uri.setter
    def base_prediction_uri(self, base_prediction_uri):
        """
        Sets the base_prediction_uri of this PredictionEndpointDetails.
        Base URI of prediction router.


        :param base_prediction_uri: The base_prediction_uri of this PredictionEndpointDetails.
        :type: str
        """
        self._base_prediction_uri = base_prediction_uri

    @property
    def prediction_uris(self):
        """
        **[Required]** Gets the prediction_uris of this PredictionEndpointDetails.
        Array of all prediction URIs per use-case.


        :return: The prediction_uris of this PredictionEndpointDetails.
        :rtype: list[oci.data_science.models.PredictionUri]
        """
        return self._prediction_uris

    @prediction_uris.setter
    def prediction_uris(self, prediction_uris):
        """
        Sets the prediction_uris of this PredictionEndpointDetails.
        Array of all prediction URIs per use-case.


        :param prediction_uris: The prediction_uris of this PredictionEndpointDetails.
        :type: list[oci.data_science.models.PredictionUri]
        """
        self._prediction_uris = prediction_uris

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
