# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RegisterModelArtifactReferenceDetails(object):
    """
    Parameters that are required to register a model artifact reference collection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new RegisterModelArtifactReferenceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param model_artifact_references:
            The value to assign to the model_artifact_references property of this RegisterModelArtifactReferenceDetails.
        :type model_artifact_references: list[oci.data_science.models.ModelArtifactReferenceDetails]

        """
        self.swagger_types = {
            'model_artifact_references': 'list[ModelArtifactReferenceDetails]'
        }
        self.attribute_map = {
            'model_artifact_references': 'modelArtifactReferences'
        }
        self._model_artifact_references = None

    @property
    def model_artifact_references(self):
        """
        **[Required]** Gets the model_artifact_references of this RegisterModelArtifactReferenceDetails.
        A list of model artifact references to register.


        :return: The model_artifact_references of this RegisterModelArtifactReferenceDetails.
        :rtype: list[oci.data_science.models.ModelArtifactReferenceDetails]
        """
        return self._model_artifact_references

    @model_artifact_references.setter
    def model_artifact_references(self, model_artifact_references):
        """
        Sets the model_artifact_references of this RegisterModelArtifactReferenceDetails.
        A list of model artifact references to register.


        :param model_artifact_references: The model_artifact_references of this RegisterModelArtifactReferenceDetails.
        :type: list[oci.data_science.models.ModelArtifactReferenceDetails]
        """
        self._model_artifact_references = model_artifact_references

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
