# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class Schedule(object):
    """
    A repeating action. Examples:
    * Invoke a ML Pipeline Run once an hour.
    * Call ML Job Run every night at midnight.
    """

    #: A constant which can be used with the lifecycle_state property of a Schedule.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a Schedule.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Schedule.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a Schedule.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a Schedule.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a Schedule.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a Schedule.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new Schedule object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this Schedule.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this Schedule.
        :type compartment_id: str

        :param project_id:
            The value to assign to the project_id property of this Schedule.
        :type project_id: str

        :param display_name:
            The value to assign to the display_name property of this Schedule.
        :type display_name: str

        :param description:
            The value to assign to the description property of this Schedule.
        :type description: str

        :param time_last_schedule_run:
            The value to assign to the time_last_schedule_run property of this Schedule.
        :type time_last_schedule_run: datetime

        :param time_next_scheduled_run:
            The value to assign to the time_next_scheduled_run property of this Schedule.
        :type time_next_scheduled_run: datetime

        :param time_created:
            The value to assign to the time_created property of this Schedule.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this Schedule.
        :type time_updated: datetime

        :param created_by:
            The value to assign to the created_by property of this Schedule.
        :type created_by: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this Schedule.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this Schedule.
        :type lifecycle_details: str

        :param last_schedule_run_details:
            The value to assign to the last_schedule_run_details property of this Schedule.
        :type last_schedule_run_details: str

        :param trigger:
            The value to assign to the trigger property of this Schedule.
        :type trigger: oci.data_science.models.ScheduleTrigger

        :param action:
            The value to assign to the action property of this Schedule.
        :type action: oci.data_science.models.ScheduleAction

        :param log_details:
            The value to assign to the log_details property of this Schedule.
        :type log_details: oci.data_science.models.ScheduleLogDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this Schedule.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this Schedule.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this Schedule.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'project_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'time_last_schedule_run': 'datetime',
            'time_next_scheduled_run': 'datetime',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'created_by': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'last_schedule_run_details': 'str',
            'trigger': 'ScheduleTrigger',
            'action': 'ScheduleAction',
            'log_details': 'ScheduleLogDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'project_id': 'projectId',
            'display_name': 'displayName',
            'description': 'description',
            'time_last_schedule_run': 'timeLastScheduleRun',
            'time_next_scheduled_run': 'timeNextScheduledRun',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'created_by': 'createdBy',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'last_schedule_run_details': 'lastScheduleRunDetails',
            'trigger': 'trigger',
            'action': 'action',
            'log_details': 'logDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._project_id = None
        self._display_name = None
        self._description = None
        self._time_last_schedule_run = None
        self._time_next_scheduled_run = None
        self._time_created = None
        self._time_updated = None
        self._created_by = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._last_schedule_run_details = None
        self._trigger = None
        self._action = None
        self._log_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this Schedule.
        The `OCID`__ of the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this Schedule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this Schedule.
        The `OCID`__ of the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this Schedule.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this Schedule.
        The `OCID`__ of the compartment where you want to create the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this Schedule.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this Schedule.
        The `OCID`__ of the compartment where you want to create the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this Schedule.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def project_id(self):
        """
        **[Required]** Gets the project_id of this Schedule.
        The `OCID`__ of the project associated with the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The project_id of this Schedule.
        :rtype: str
        """
        return self._project_id

    @project_id.setter
    def project_id(self, project_id):
        """
        Sets the project_id of this Schedule.
        The `OCID`__ of the project associated with the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param project_id: The project_id of this Schedule.
        :type: str
        """
        self._project_id = project_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this Schedule.
        A user-friendly display name for the resource. Avoid entering confidential information.


        :return: The display_name of this Schedule.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this Schedule.
        A user-friendly display name for the resource. Avoid entering confidential information.


        :param display_name: The display_name of this Schedule.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this Schedule.
        A short description of the schedule.


        :return: The description of this Schedule.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this Schedule.
        A short description of the schedule.


        :param description: The description of this Schedule.
        :type: str
        """
        self._description = description

    @property
    def time_last_schedule_run(self):
        """
        Gets the time_last_schedule_run of this Schedule.
        The last schedule execution time.
        Format is defined by RFC3339.
        Example: `2022-08-05T01:02:29.600Z`


        :return: The time_last_schedule_run of this Schedule.
        :rtype: datetime
        """
        return self._time_last_schedule_run

    @time_last_schedule_run.setter
    def time_last_schedule_run(self, time_last_schedule_run):
        """
        Sets the time_last_schedule_run of this Schedule.
        The last schedule execution time.
        Format is defined by RFC3339.
        Example: `2022-08-05T01:02:29.600Z`


        :param time_last_schedule_run: The time_last_schedule_run of this Schedule.
        :type: datetime
        """
        self._time_last_schedule_run = time_last_schedule_run

    @property
    def time_next_scheduled_run(self):
        """
        Gets the time_next_scheduled_run of this Schedule.
        The next scheduled execution time for the schedule.
        Format is defined by RFC3339.
        Example: `2022-08-05T01:02:29.600Z`


        :return: The time_next_scheduled_run of this Schedule.
        :rtype: datetime
        """
        return self._time_next_scheduled_run

    @time_next_scheduled_run.setter
    def time_next_scheduled_run(self, time_next_scheduled_run):
        """
        Sets the time_next_scheduled_run of this Schedule.
        The next scheduled execution time for the schedule.
        Format is defined by RFC3339.
        Example: `2022-08-05T01:02:29.600Z`


        :param time_next_scheduled_run: The time_next_scheduled_run of this Schedule.
        :type: datetime
        """
        self._time_next_scheduled_run = time_next_scheduled_run

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this Schedule.
        The date and time the schedule was created.
        Format is defined by RFC3339.
        Example: `2022-08-05T01:02:29.600Z`


        :return: The time_created of this Schedule.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this Schedule.
        The date and time the schedule was created.
        Format is defined by RFC3339.
        Example: `2022-08-05T01:02:29.600Z`


        :param time_created: The time_created of this Schedule.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this Schedule.
        The date and time the schedule was updated.
        Format is defined by RFC3339.
        Example: `2022-09-05T01:02:29.600Z`


        :return: The time_updated of this Schedule.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this Schedule.
        The date and time the schedule was updated.
        Format is defined by RFC3339.
        Example: `2022-09-05T01:02:29.600Z`


        :param time_updated: The time_updated of this Schedule.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this Schedule.
        The `OCID`__ of the user who created the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The created_by of this Schedule.
        :rtype: str
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this Schedule.
        The `OCID`__ of the user who created the schedule.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param created_by: The created_by of this Schedule.
        :type: str
        """
        self._created_by = created_by

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this Schedule.
        The current state of the schedule.
        Example: `ACTIVE`

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this Schedule.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this Schedule.
        The current state of the schedule.
        Example: `ACTIVE`


        :param lifecycle_state: The lifecycle_state of this Schedule.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this Schedule.
        A message describing the current state in more detail.


        :return: The lifecycle_details of this Schedule.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this Schedule.
        A message describing the current state in more detail.


        :param lifecycle_details: The lifecycle_details of this Schedule.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def last_schedule_run_details(self):
        """
        Gets the last_schedule_run_details of this Schedule.
        Details about the action performed by the last schedule execution.
        Example: `Invoked ML Application trigger.`


        :return: The last_schedule_run_details of this Schedule.
        :rtype: str
        """
        return self._last_schedule_run_details

    @last_schedule_run_details.setter
    def last_schedule_run_details(self, last_schedule_run_details):
        """
        Sets the last_schedule_run_details of this Schedule.
        Details about the action performed by the last schedule execution.
        Example: `Invoked ML Application trigger.`


        :param last_schedule_run_details: The last_schedule_run_details of this Schedule.
        :type: str
        """
        self._last_schedule_run_details = last_schedule_run_details

    @property
    def trigger(self):
        """
        **[Required]** Gets the trigger of this Schedule.

        :return: The trigger of this Schedule.
        :rtype: oci.data_science.models.ScheduleTrigger
        """
        return self._trigger

    @trigger.setter
    def trigger(self, trigger):
        """
        Sets the trigger of this Schedule.

        :param trigger: The trigger of this Schedule.
        :type: oci.data_science.models.ScheduleTrigger
        """
        self._trigger = trigger

    @property
    def action(self):
        """
        **[Required]** Gets the action of this Schedule.

        :return: The action of this Schedule.
        :rtype: oci.data_science.models.ScheduleAction
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this Schedule.

        :param action: The action of this Schedule.
        :type: oci.data_science.models.ScheduleAction
        """
        self._action = action

    @property
    def log_details(self):
        """
        Gets the log_details of this Schedule.

        :return: The log_details of this Schedule.
        :rtype: oci.data_science.models.ScheduleLogDetails
        """
        return self._log_details

    @log_details.setter
    def log_details(self, log_details):
        """
        Sets the log_details of this Schedule.

        :param log_details: The log_details of this Schedule.
        :type: oci.data_science.models.ScheduleLogDetails
        """
        self._log_details = log_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this Schedule.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this Schedule.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this Schedule.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. See `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this Schedule.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this Schedule.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this Schedule.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this Schedule.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. See `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this Schedule.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this Schedule.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this Schedule.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this Schedule.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this Schedule.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
