# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .update_model_deployment_configuration_details import UpdateModelDeploymentConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateModelGroupDeploymentConfigurationDetails(UpdateModelDeploymentConfigurationDetails):
    """
    The model group type deployment for update.
    """

    #: A constant which can be used with the update_type property of a UpdateModelGroupDeploymentConfigurationDetails.
    #: This constant has a value of "ZDT"
    UPDATE_TYPE_ZDT = "ZDT"

    #: A constant which can be used with the update_type property of a UpdateModelGroupDeploymentConfigurationDetails.
    #: This constant has a value of "LIVE"
    UPDATE_TYPE_LIVE = "LIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateModelGroupDeploymentConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.UpdateModelGroupDeploymentConfigurationDetails.deployment_type` attribute
        of this class is ``MODEL_GROUP`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param deployment_type:
            The value to assign to the deployment_type property of this UpdateModelGroupDeploymentConfigurationDetails.
            Allowed values for this property are: "SINGLE_MODEL", "MODEL_GROUP"
        :type deployment_type: str

        :param update_type:
            The value to assign to the update_type property of this UpdateModelGroupDeploymentConfigurationDetails.
            Allowed values for this property are: "ZDT", "LIVE"
        :type update_type: str

        :param model_group_configuration_details:
            The value to assign to the model_group_configuration_details property of this UpdateModelGroupDeploymentConfigurationDetails.
        :type model_group_configuration_details: oci.data_science.models.UpdateModelGroupConfigurationDetails

        :param infrastructure_configuration_details:
            The value to assign to the infrastructure_configuration_details property of this UpdateModelGroupDeploymentConfigurationDetails.
        :type infrastructure_configuration_details: oci.data_science.models.UpdateInfrastructureConfigurationDetails

        :param environment_configuration_details:
            The value to assign to the environment_configuration_details property of this UpdateModelGroupDeploymentConfigurationDetails.
        :type environment_configuration_details: oci.data_science.models.UpdateModelDeploymentEnvironmentConfigurationDetails

        """
        self.swagger_types = {
            'deployment_type': 'str',
            'update_type': 'str',
            'model_group_configuration_details': 'UpdateModelGroupConfigurationDetails',
            'infrastructure_configuration_details': 'UpdateInfrastructureConfigurationDetails',
            'environment_configuration_details': 'UpdateModelDeploymentEnvironmentConfigurationDetails'
        }
        self.attribute_map = {
            'deployment_type': 'deploymentType',
            'update_type': 'updateType',
            'model_group_configuration_details': 'modelGroupConfigurationDetails',
            'infrastructure_configuration_details': 'infrastructureConfigurationDetails',
            'environment_configuration_details': 'environmentConfigurationDetails'
        }
        self._deployment_type = None
        self._update_type = None
        self._model_group_configuration_details = None
        self._infrastructure_configuration_details = None
        self._environment_configuration_details = None
        self._deployment_type = 'MODEL_GROUP'

    @property
    def update_type(self):
        """
        Gets the update_type of this UpdateModelGroupDeploymentConfigurationDetails.
        The type of update operation.

        Allowed values for this property are: "ZDT", "LIVE"


        :return: The update_type of this UpdateModelGroupDeploymentConfigurationDetails.
        :rtype: str
        """
        return self._update_type

    @update_type.setter
    def update_type(self, update_type):
        """
        Sets the update_type of this UpdateModelGroupDeploymentConfigurationDetails.
        The type of update operation.


        :param update_type: The update_type of this UpdateModelGroupDeploymentConfigurationDetails.
        :type: str
        """
        allowed_values = ["ZDT", "LIVE"]
        if not value_allowed_none_or_none_sentinel(update_type, allowed_values):
            raise ValueError(
                f"Invalid value for `update_type`, must be None or one of {allowed_values}"
            )
        self._update_type = update_type

    @property
    def model_group_configuration_details(self):
        """
        Gets the model_group_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.

        :return: The model_group_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.
        :rtype: oci.data_science.models.UpdateModelGroupConfigurationDetails
        """
        return self._model_group_configuration_details

    @model_group_configuration_details.setter
    def model_group_configuration_details(self, model_group_configuration_details):
        """
        Sets the model_group_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.

        :param model_group_configuration_details: The model_group_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.
        :type: oci.data_science.models.UpdateModelGroupConfigurationDetails
        """
        self._model_group_configuration_details = model_group_configuration_details

    @property
    def infrastructure_configuration_details(self):
        """
        Gets the infrastructure_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.

        :return: The infrastructure_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.
        :rtype: oci.data_science.models.UpdateInfrastructureConfigurationDetails
        """
        return self._infrastructure_configuration_details

    @infrastructure_configuration_details.setter
    def infrastructure_configuration_details(self, infrastructure_configuration_details):
        """
        Sets the infrastructure_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.

        :param infrastructure_configuration_details: The infrastructure_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.
        :type: oci.data_science.models.UpdateInfrastructureConfigurationDetails
        """
        self._infrastructure_configuration_details = infrastructure_configuration_details

    @property
    def environment_configuration_details(self):
        """
        Gets the environment_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.

        :return: The environment_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.
        :rtype: oci.data_science.models.UpdateModelDeploymentEnvironmentConfigurationDetails
        """
        return self._environment_configuration_details

    @environment_configuration_details.setter
    def environment_configuration_details(self, environment_configuration_details):
        """
        Sets the environment_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.

        :param environment_configuration_details: The environment_configuration_details of this UpdateModelGroupDeploymentConfigurationDetails.
        :type: oci.data_science.models.UpdateModelDeploymentEnvironmentConfigurationDetails
        """
        self._environment_configuration_details = environment_configuration_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
