# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DbConnectionBundle(object):
    """
    Details of a database connection bundle.
    """

    #: A constant which can be used with the lifecycle_state property of a DbConnectionBundle.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DbConnectionBundle.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbConnectionBundle.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DbConnectionBundle.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DbConnectionBundle.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DbConnectionBundle.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DbConnectionBundle.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the db_connection_bundle_type property of a DbConnectionBundle.
    #: This constant has a value of "TLS"
    DB_CONNECTION_BUNDLE_TYPE_TLS = "TLS"

    #: A constant which can be used with the db_connection_bundle_type property of a DbConnectionBundle.
    #: This constant has a value of "MTLS"
    DB_CONNECTION_BUNDLE_TYPE_MTLS = "MTLS"

    def __init__(self, **kwargs):
        """
        Initializes a new DbConnectionBundle object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this DbConnectionBundle.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this DbConnectionBundle.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this DbConnectionBundle.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this DbConnectionBundle.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this DbConnectionBundle.
        :type time_updated: datetime

        :param time_last_refreshed:
            The value to assign to the time_last_refreshed property of this DbConnectionBundle.
        :type time_last_refreshed: datetime

        :param associated_resource_details:
            The value to assign to the associated_resource_details property of this DbConnectionBundle.
        :type associated_resource_details: list[oci.database.models.AssociatedResourceDetails]

        :param is_protected:
            The value to assign to the is_protected property of this DbConnectionBundle.
        :type is_protected: bool

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DbConnectionBundle.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DbConnectionBundle.
        :type defined_tags: dict(str, dict(str, str))

        :param system_tags:
            The value to assign to the system_tags property of this DbConnectionBundle.
        :type system_tags: dict(str, dict(str, str))

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DbConnectionBundle.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param db_connection_bundle_type:
            The value to assign to the db_connection_bundle_type property of this DbConnectionBundle.
            Allowed values for this property are: "TLS", "MTLS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type db_connection_bundle_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_last_refreshed': 'datetime',
            'associated_resource_details': 'list[AssociatedResourceDetails]',
            'is_protected': 'bool',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, str))',
            'system_tags': 'dict(str, dict(str, str))',
            'lifecycle_state': 'str',
            'db_connection_bundle_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_last_refreshed': 'timeLastRefreshed',
            'associated_resource_details': 'associatedResourceDetails',
            'is_protected': 'isProtected',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'lifecycle_state': 'lifecycleState',
            'db_connection_bundle_type': 'dbConnectionBundleType'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._time_created = None
        self._time_updated = None
        self._time_last_refreshed = None
        self._associated_resource_details = None
        self._is_protected = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._lifecycle_state = None
        self._db_connection_bundle_type = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this DbConnectionBundle.
        The OCID of the database connection bundle.


        :return: The id of this DbConnectionBundle.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DbConnectionBundle.
        The OCID of the database connection bundle.


        :param id: The id of this DbConnectionBundle.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this DbConnectionBundle.
        The OCID of the compartment containing the database connection bundle.


        :return: The compartment_id of this DbConnectionBundle.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this DbConnectionBundle.
        The OCID of the compartment containing the database connection bundle.


        :param compartment_id: The compartment_id of this DbConnectionBundle.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this DbConnectionBundle.
        Display name for the connection bundle.


        :return: The display_name of this DbConnectionBundle.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this DbConnectionBundle.
        Display name for the connection bundle.


        :param display_name: The display_name of this DbConnectionBundle.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this DbConnectionBundle.
        The time the database connection bundle was created. An RFC3339 formatted datetime string.


        :return: The time_created of this DbConnectionBundle.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this DbConnectionBundle.
        The time the database connection bundle was created. An RFC3339 formatted datetime string.


        :param time_created: The time_created of this DbConnectionBundle.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this DbConnectionBundle.
        The time the database connection bundle was updated. An RFC3339 formatted datetime string.


        :return: The time_updated of this DbConnectionBundle.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this DbConnectionBundle.
        The time the database connection bundle was updated. An RFC3339 formatted datetime string.


        :param time_updated: The time_updated of this DbConnectionBundle.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def time_last_refreshed(self):
        """
        Gets the time_last_refreshed of this DbConnectionBundle.
        The time the database connection bundle was last refreshed. An RFC3339 formatted datetime string.


        :return: The time_last_refreshed of this DbConnectionBundle.
        :rtype: datetime
        """
        return self._time_last_refreshed

    @time_last_refreshed.setter
    def time_last_refreshed(self, time_last_refreshed):
        """
        Sets the time_last_refreshed of this DbConnectionBundle.
        The time the database connection bundle was last refreshed. An RFC3339 formatted datetime string.


        :param time_last_refreshed: The time_last_refreshed of this DbConnectionBundle.
        :type: datetime
        """
        self._time_last_refreshed = time_last_refreshed

    @property
    def associated_resource_details(self):
        """
        Gets the associated_resource_details of this DbConnectionBundle.
        Details about the resources associated with the connection bundle.


        :return: The associated_resource_details of this DbConnectionBundle.
        :rtype: list[oci.database.models.AssociatedResourceDetails]
        """
        return self._associated_resource_details

    @associated_resource_details.setter
    def associated_resource_details(self, associated_resource_details):
        """
        Sets the associated_resource_details of this DbConnectionBundle.
        Details about the resources associated with the connection bundle.


        :param associated_resource_details: The associated_resource_details of this DbConnectionBundle.
        :type: list[oci.database.models.AssociatedResourceDetails]
        """
        self._associated_resource_details = associated_resource_details

    @property
    def is_protected(self):
        """
        **[Required]** Gets the is_protected of this DbConnectionBundle.
        True for the default, service-created Database Connection Bundle.


        :return: The is_protected of this DbConnectionBundle.
        :rtype: bool
        """
        return self._is_protected

    @is_protected.setter
    def is_protected(self, is_protected):
        """
        Sets the is_protected of this DbConnectionBundle.
        True for the default, service-created Database Connection Bundle.


        :param is_protected: The is_protected of this DbConnectionBundle.
        :type: bool
        """
        self._is_protected = is_protected

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this DbConnectionBundle.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this DbConnectionBundle.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DbConnectionBundle.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this DbConnectionBundle.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this DbConnectionBundle.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this DbConnectionBundle.
        :rtype: dict(str, dict(str, str))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DbConnectionBundle.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this DbConnectionBundle.
        :type: dict(str, dict(str, str))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this DbConnectionBundle.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this DbConnectionBundle.
        :rtype: dict(str, dict(str, str))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DbConnectionBundle.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this DbConnectionBundle.
        :type: dict(str, dict(str, str))
        """
        self._system_tags = system_tags

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this DbConnectionBundle.
        The current lifecycle state of the database connection bundle.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DbConnectionBundle.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DbConnectionBundle.
        The current lifecycle state of the database connection bundle.


        :param lifecycle_state: The lifecycle_state of this DbConnectionBundle.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def db_connection_bundle_type(self):
        """
        **[Required]** Gets the db_connection_bundle_type of this DbConnectionBundle.
        The type of the database connection bundle.

        Allowed values for this property are: "TLS", "MTLS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The db_connection_bundle_type of this DbConnectionBundle.
        :rtype: str
        """
        return self._db_connection_bundle_type

    @db_connection_bundle_type.setter
    def db_connection_bundle_type(self, db_connection_bundle_type):
        """
        Sets the db_connection_bundle_type of this DbConnectionBundle.
        The type of the database connection bundle.


        :param db_connection_bundle_type: The db_connection_bundle_type of this DbConnectionBundle.
        :type: str
        """
        allowed_values = ["TLS", "MTLS"]
        if not value_allowed_none_or_none_sentinel(db_connection_bundle_type, allowed_values):
            db_connection_bundle_type = 'UNKNOWN_ENUM_VALUE'
        self._db_connection_bundle_type = db_connection_bundle_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
