# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class RunDataPatchDetails(object):
    """
    Details for running datapatch operation on a database and its pluggable databases
    """

    #: A constant which can be used with the action property of a RunDataPatchDetails.
    #: This constant has a value of "APPLY"
    ACTION_APPLY = "APPLY"

    #: A constant which can be used with the action property of a RunDataPatchDetails.
    #: This constant has a value of "PRECHECK"
    ACTION_PRECHECK = "PRECHECK"

    def __init__(self, **kwargs):
        """
        Initializes a new RunDataPatchDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pluggable_databases:
            The value to assign to the pluggable_databases property of this RunDataPatchDetails.
        :type pluggable_databases: list[str]

        :param data_patch_options:
            The value to assign to the data_patch_options property of this RunDataPatchDetails.
        :type data_patch_options: oci.database.models.DataPatchOptions

        :param action:
            The value to assign to the action property of this RunDataPatchDetails.
            Allowed values for this property are: "APPLY", "PRECHECK"
        :type action: str

        """
        self.swagger_types = {
            'pluggable_databases': 'list[str]',
            'data_patch_options': 'DataPatchOptions',
            'action': 'str'
        }
        self.attribute_map = {
            'pluggable_databases': 'pluggableDatabases',
            'data_patch_options': 'dataPatchOptions',
            'action': 'action'
        }
        self._pluggable_databases = None
        self._data_patch_options = None
        self._action = None

    @property
    def pluggable_databases(self):
        """
        Gets the pluggable_databases of this RunDataPatchDetails.
        List of Pluggable Database `OCIDs`__ to run datapatch on. The datapatch would run on the database first and then the given pluggable databases.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The pluggable_databases of this RunDataPatchDetails.
        :rtype: list[str]
        """
        return self._pluggable_databases

    @pluggable_databases.setter
    def pluggable_databases(self, pluggable_databases):
        """
        Sets the pluggable_databases of this RunDataPatchDetails.
        List of Pluggable Database `OCIDs`__ to run datapatch on. The datapatch would run on the database first and then the given pluggable databases.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param pluggable_databases: The pluggable_databases of this RunDataPatchDetails.
        :type: list[str]
        """
        self._pluggable_databases = pluggable_databases

    @property
    def data_patch_options(self):
        """
        Gets the data_patch_options of this RunDataPatchDetails.

        :return: The data_patch_options of this RunDataPatchDetails.
        :rtype: oci.database.models.DataPatchOptions
        """
        return self._data_patch_options

    @data_patch_options.setter
    def data_patch_options(self, data_patch_options):
        """
        Sets the data_patch_options of this RunDataPatchDetails.

        :param data_patch_options: The data_patch_options of this RunDataPatchDetails.
        :type: oci.database.models.DataPatchOptions
        """
        self._data_patch_options = data_patch_options

    @property
    def action(self):
        """
        Gets the action of this RunDataPatchDetails.
        The action to perform on run database dataPatch operation

        Allowed values for this property are: "APPLY", "PRECHECK"


        :return: The action of this RunDataPatchDetails.
        :rtype: str
        """
        return self._action

    @action.setter
    def action(self, action):
        """
        Sets the action of this RunDataPatchDetails.
        The action to perform on run database dataPatch operation


        :param action: The action of this RunDataPatchDetails.
        :type: str
        """
        allowed_values = ["APPLY", "PRECHECK"]
        if not value_allowed_none_or_none_sentinel(action, allowed_values):
            raise ValueError(
                f"Invalid value for `action`, must be None or one of {allowed_values}"
            )
        self._action = action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
