# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VmClusterSummary(object):
    """
    Details of the Exadata Cloud@Customer VM cluster.
    """

    #: A constant which can be used with the lifecycle_state property of a VmClusterSummary.
    #: This constant has a value of "PROVISIONING"
    LIFECYCLE_STATE_PROVISIONING = "PROVISIONING"

    #: A constant which can be used with the lifecycle_state property of a VmClusterSummary.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a VmClusterSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a VmClusterSummary.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a VmClusterSummary.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the lifecycle_state property of a VmClusterSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a VmClusterSummary.
    #: This constant has a value of "MAINTENANCE_IN_PROGRESS"
    LIFECYCLE_STATE_MAINTENANCE_IN_PROGRESS = "MAINTENANCE_IN_PROGRESS"

    #: A constant which can be used with the license_model property of a VmClusterSummary.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a VmClusterSummary.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    #: A constant which can be used with the vm_cluster_type property of a VmClusterSummary.
    #: This constant has a value of "REGULAR"
    VM_CLUSTER_TYPE_REGULAR = "REGULAR"

    #: A constant which can be used with the vm_cluster_type property of a VmClusterSummary.
    #: This constant has a value of "DEVELOPER"
    VM_CLUSTER_TYPE_DEVELOPER = "DEVELOPER"

    #: A constant which can be used with the storage_management_type property of a VmClusterSummary.
    #: This constant has a value of "ASM"
    STORAGE_MANAGEMENT_TYPE_ASM = "ASM"

    #: A constant which can be used with the storage_management_type property of a VmClusterSummary.
    #: This constant has a value of "EXASCALE"
    STORAGE_MANAGEMENT_TYPE_EXASCALE = "EXASCALE"

    #: A constant which can be used with the compute_model property of a VmClusterSummary.
    #: This constant has a value of "ECPU"
    COMPUTE_MODEL_ECPU = "ECPU"

    #: A constant which can be used with the compute_model property of a VmClusterSummary.
    #: This constant has a value of "OCPU"
    COMPUTE_MODEL_OCPU = "OCPU"

    #: A constant which can be used with the vm_file_system_storage_type property of a VmClusterSummary.
    #: This constant has a value of "LOCAL"
    VM_FILE_SYSTEM_STORAGE_TYPE_LOCAL = "LOCAL"

    #: A constant which can be used with the vm_file_system_storage_type property of a VmClusterSummary.
    #: This constant has a value of "EXASCALE"
    VM_FILE_SYSTEM_STORAGE_TYPE_EXASCALE = "EXASCALE"

    #: A constant which can be used with the vm_backup_storage_type property of a VmClusterSummary.
    #: This constant has a value of "LOCAL"
    VM_BACKUP_STORAGE_TYPE_LOCAL = "LOCAL"

    #: A constant which can be used with the vm_backup_storage_type property of a VmClusterSummary.
    #: This constant has a value of "EXASCALE"
    VM_BACKUP_STORAGE_TYPE_EXASCALE = "EXASCALE"

    def __init__(self, **kwargs):
        """
        Initializes a new VmClusterSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this VmClusterSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this VmClusterSummary.
        :type compartment_id: str

        :param last_patch_history_entry_id:
            The value to assign to the last_patch_history_entry_id property of this VmClusterSummary.
        :type last_patch_history_entry_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this VmClusterSummary.
            Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param display_name:
            The value to assign to the display_name property of this VmClusterSummary.
        :type display_name: str

        :param time_created:
            The value to assign to the time_created property of this VmClusterSummary.
        :type time_created: datetime

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this VmClusterSummary.
        :type lifecycle_details: str

        :param time_zone:
            The value to assign to the time_zone property of this VmClusterSummary.
        :type time_zone: str

        :param is_local_backup_enabled:
            The value to assign to the is_local_backup_enabled property of this VmClusterSummary.
        :type is_local_backup_enabled: bool

        :param exadata_infrastructure_id:
            The value to assign to the exadata_infrastructure_id property of this VmClusterSummary.
        :type exadata_infrastructure_id: str

        :param is_sparse_diskgroup_enabled:
            The value to assign to the is_sparse_diskgroup_enabled property of this VmClusterSummary.
        :type is_sparse_diskgroup_enabled: bool

        :param vm_cluster_network_id:
            The value to assign to the vm_cluster_network_id property of this VmClusterSummary.
        :type vm_cluster_network_id: str

        :param cpus_enabled:
            The value to assign to the cpus_enabled property of this VmClusterSummary.
        :type cpus_enabled: int

        :param ocpus_enabled:
            The value to assign to the ocpus_enabled property of this VmClusterSummary.
        :type ocpus_enabled: float

        :param memory_size_in_gbs:
            The value to assign to the memory_size_in_gbs property of this VmClusterSummary.
        :type memory_size_in_gbs: int

        :param db_node_storage_size_in_gbs:
            The value to assign to the db_node_storage_size_in_gbs property of this VmClusterSummary.
        :type db_node_storage_size_in_gbs: int

        :param data_storage_size_in_tbs:
            The value to assign to the data_storage_size_in_tbs property of this VmClusterSummary.
        :type data_storage_size_in_tbs: float

        :param data_storage_size_in_gbs:
            The value to assign to the data_storage_size_in_gbs property of this VmClusterSummary.
        :type data_storage_size_in_gbs: float

        :param shape:
            The value to assign to the shape property of this VmClusterSummary.
        :type shape: str

        :param gi_version:
            The value to assign to the gi_version property of this VmClusterSummary.
        :type gi_version: str

        :param system_version:
            The value to assign to the system_version property of this VmClusterSummary.
        :type system_version: str

        :param ssh_public_keys:
            The value to assign to the ssh_public_keys property of this VmClusterSummary.
        :type ssh_public_keys: list[str]

        :param license_model:
            The value to assign to the license_model property of this VmClusterSummary.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type license_model: str

        :param db_servers:
            The value to assign to the db_servers property of this VmClusterSummary.
        :type db_servers: list[str]

        :param availability_domain:
            The value to assign to the availability_domain property of this VmClusterSummary.
        :type availability_domain: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this VmClusterSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this VmClusterSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this VmClusterSummary.
        :type system_tags: dict(str, dict(str, object))

        :param data_collection_options:
            The value to assign to the data_collection_options property of this VmClusterSummary.
        :type data_collection_options: oci.database.models.DataCollectionOptions

        :param gi_software_image_id:
            The value to assign to the gi_software_image_id property of this VmClusterSummary.
        :type gi_software_image_id: str

        :param file_system_configuration_details:
            The value to assign to the file_system_configuration_details property of this VmClusterSummary.
        :type file_system_configuration_details: list[oci.database.models.FileSystemConfigurationDetail]

        :param vm_cluster_type:
            The value to assign to the vm_cluster_type property of this VmClusterSummary.
            Allowed values for this property are: "REGULAR", "DEVELOPER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vm_cluster_type: str

        :param cloud_automation_update_details:
            The value to assign to the cloud_automation_update_details property of this VmClusterSummary.
        :type cloud_automation_update_details: oci.database.models.CloudAutomationUpdateDetails

        :param exascale_db_storage_vault_id:
            The value to assign to the exascale_db_storage_vault_id property of this VmClusterSummary.
        :type exascale_db_storage_vault_id: str

        :param storage_management_type:
            The value to assign to the storage_management_type property of this VmClusterSummary.
            Allowed values for this property are: "ASM", "EXASCALE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type storage_management_type: str

        :param compute_model:
            The value to assign to the compute_model property of this VmClusterSummary.
            Allowed values for this property are: "ECPU", "OCPU", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type compute_model: str

        :param vm_file_system_storage_type:
            The value to assign to the vm_file_system_storage_type property of this VmClusterSummary.
            Allowed values for this property are: "LOCAL", "EXASCALE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vm_file_system_storage_type: str

        :param vm_backup_storage_type:
            The value to assign to the vm_backup_storage_type property of this VmClusterSummary.
            Allowed values for this property are: "LOCAL", "EXASCALE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vm_backup_storage_type: str

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'last_patch_history_entry_id': 'str',
            'lifecycle_state': 'str',
            'display_name': 'str',
            'time_created': 'datetime',
            'lifecycle_details': 'str',
            'time_zone': 'str',
            'is_local_backup_enabled': 'bool',
            'exadata_infrastructure_id': 'str',
            'is_sparse_diskgroup_enabled': 'bool',
            'vm_cluster_network_id': 'str',
            'cpus_enabled': 'int',
            'ocpus_enabled': 'float',
            'memory_size_in_gbs': 'int',
            'db_node_storage_size_in_gbs': 'int',
            'data_storage_size_in_tbs': 'float',
            'data_storage_size_in_gbs': 'float',
            'shape': 'str',
            'gi_version': 'str',
            'system_version': 'str',
            'ssh_public_keys': 'list[str]',
            'license_model': 'str',
            'db_servers': 'list[str]',
            'availability_domain': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'data_collection_options': 'DataCollectionOptions',
            'gi_software_image_id': 'str',
            'file_system_configuration_details': 'list[FileSystemConfigurationDetail]',
            'vm_cluster_type': 'str',
            'cloud_automation_update_details': 'CloudAutomationUpdateDetails',
            'exascale_db_storage_vault_id': 'str',
            'storage_management_type': 'str',
            'compute_model': 'str',
            'vm_file_system_storage_type': 'str',
            'vm_backup_storage_type': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'last_patch_history_entry_id': 'lastPatchHistoryEntryId',
            'lifecycle_state': 'lifecycleState',
            'display_name': 'displayName',
            'time_created': 'timeCreated',
            'lifecycle_details': 'lifecycleDetails',
            'time_zone': 'timeZone',
            'is_local_backup_enabled': 'isLocalBackupEnabled',
            'exadata_infrastructure_id': 'exadataInfrastructureId',
            'is_sparse_diskgroup_enabled': 'isSparseDiskgroupEnabled',
            'vm_cluster_network_id': 'vmClusterNetworkId',
            'cpus_enabled': 'cpusEnabled',
            'ocpus_enabled': 'ocpusEnabled',
            'memory_size_in_gbs': 'memorySizeInGBs',
            'db_node_storage_size_in_gbs': 'dbNodeStorageSizeInGBs',
            'data_storage_size_in_tbs': 'dataStorageSizeInTBs',
            'data_storage_size_in_gbs': 'dataStorageSizeInGBs',
            'shape': 'shape',
            'gi_version': 'giVersion',
            'system_version': 'systemVersion',
            'ssh_public_keys': 'sshPublicKeys',
            'license_model': 'licenseModel',
            'db_servers': 'dbServers',
            'availability_domain': 'availabilityDomain',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'data_collection_options': 'dataCollectionOptions',
            'gi_software_image_id': 'giSoftwareImageId',
            'file_system_configuration_details': 'fileSystemConfigurationDetails',
            'vm_cluster_type': 'vmClusterType',
            'cloud_automation_update_details': 'cloudAutomationUpdateDetails',
            'exascale_db_storage_vault_id': 'exascaleDbStorageVaultId',
            'storage_management_type': 'storageManagementType',
            'compute_model': 'computeModel',
            'vm_file_system_storage_type': 'vmFileSystemStorageType',
            'vm_backup_storage_type': 'vmBackupStorageType'
        }
        self._id = None
        self._compartment_id = None
        self._last_patch_history_entry_id = None
        self._lifecycle_state = None
        self._display_name = None
        self._time_created = None
        self._lifecycle_details = None
        self._time_zone = None
        self._is_local_backup_enabled = None
        self._exadata_infrastructure_id = None
        self._is_sparse_diskgroup_enabled = None
        self._vm_cluster_network_id = None
        self._cpus_enabled = None
        self._ocpus_enabled = None
        self._memory_size_in_gbs = None
        self._db_node_storage_size_in_gbs = None
        self._data_storage_size_in_tbs = None
        self._data_storage_size_in_gbs = None
        self._shape = None
        self._gi_version = None
        self._system_version = None
        self._ssh_public_keys = None
        self._license_model = None
        self._db_servers = None
        self._availability_domain = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._data_collection_options = None
        self._gi_software_image_id = None
        self._file_system_configuration_details = None
        self._vm_cluster_type = None
        self._cloud_automation_update_details = None
        self._exascale_db_storage_vault_id = None
        self._storage_management_type = None
        self._compute_model = None
        self._vm_file_system_storage_type = None
        self._vm_backup_storage_type = None

    @property
    def id(self):
        """
        Gets the id of this VmClusterSummary.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this VmClusterSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this VmClusterSummary.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this VmClusterSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this VmClusterSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this VmClusterSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this VmClusterSummary.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this VmClusterSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def last_patch_history_entry_id(self):
        """
        Gets the last_patch_history_entry_id of this VmClusterSummary.
        The `OCID`__ of the last patch history. This value is updated as soon as a patch operation starts.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The last_patch_history_entry_id of this VmClusterSummary.
        :rtype: str
        """
        return self._last_patch_history_entry_id

    @last_patch_history_entry_id.setter
    def last_patch_history_entry_id(self, last_patch_history_entry_id):
        """
        Sets the last_patch_history_entry_id of this VmClusterSummary.
        The `OCID`__ of the last patch history. This value is updated as soon as a patch operation starts.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param last_patch_history_entry_id: The last_patch_history_entry_id of this VmClusterSummary.
        :type: str
        """
        self._last_patch_history_entry_id = last_patch_history_entry_id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this VmClusterSummary.
        The current state of the VM cluster.

        Allowed values for this property are: "PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this VmClusterSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this VmClusterSummary.
        The current state of the VM cluster.


        :param lifecycle_state: The lifecycle_state of this VmClusterSummary.
        :type: str
        """
        allowed_values = ["PROVISIONING", "AVAILABLE", "UPDATING", "TERMINATING", "TERMINATED", "FAILED", "MAINTENANCE_IN_PROGRESS"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def display_name(self):
        """
        Gets the display_name of this VmClusterSummary.
        The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.


        :return: The display_name of this VmClusterSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this VmClusterSummary.
        The user-friendly name for the Exadata Cloud@Customer VM cluster. The name does not need to be unique.


        :param display_name: The display_name of this VmClusterSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def time_created(self):
        """
        Gets the time_created of this VmClusterSummary.
        The date and time that the VM cluster was created.


        :return: The time_created of this VmClusterSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this VmClusterSummary.
        The date and time that the VM cluster was created.


        :param time_created: The time_created of this VmClusterSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this VmClusterSummary.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this VmClusterSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this VmClusterSummary.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this VmClusterSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_zone(self):
        """
        Gets the time_zone of this VmClusterSummary.
        The time zone of the Exadata infrastructure. For details, see `Exadata Infrastructure Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :return: The time_zone of this VmClusterSummary.
        :rtype: str
        """
        return self._time_zone

    @time_zone.setter
    def time_zone(self, time_zone):
        """
        Sets the time_zone of this VmClusterSummary.
        The time zone of the Exadata infrastructure. For details, see `Exadata Infrastructure Time Zones`__.

        __ https://docs.cloud.oracle.com/Content/Database/References/timezones.htm


        :param time_zone: The time_zone of this VmClusterSummary.
        :type: str
        """
        self._time_zone = time_zone

    @property
    def is_local_backup_enabled(self):
        """
        Gets the is_local_backup_enabled of this VmClusterSummary.
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.


        :return: The is_local_backup_enabled of this VmClusterSummary.
        :rtype: bool
        """
        return self._is_local_backup_enabled

    @is_local_backup_enabled.setter
    def is_local_backup_enabled(self, is_local_backup_enabled):
        """
        Sets the is_local_backup_enabled of this VmClusterSummary.
        If true, database backup on local Exadata storage is configured for the VM cluster. If false, database backup on local Exadata storage is not available in the VM cluster.


        :param is_local_backup_enabled: The is_local_backup_enabled of this VmClusterSummary.
        :type: bool
        """
        self._is_local_backup_enabled = is_local_backup_enabled

    @property
    def exadata_infrastructure_id(self):
        """
        Gets the exadata_infrastructure_id of this VmClusterSummary.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The exadata_infrastructure_id of this VmClusterSummary.
        :rtype: str
        """
        return self._exadata_infrastructure_id

    @exadata_infrastructure_id.setter
    def exadata_infrastructure_id(self, exadata_infrastructure_id):
        """
        Sets the exadata_infrastructure_id of this VmClusterSummary.
        The `OCID`__ of the Exadata infrastructure.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param exadata_infrastructure_id: The exadata_infrastructure_id of this VmClusterSummary.
        :type: str
        """
        self._exadata_infrastructure_id = exadata_infrastructure_id

    @property
    def is_sparse_diskgroup_enabled(self):
        """
        Gets the is_sparse_diskgroup_enabled of this VmClusterSummary.
        If true, sparse disk group is configured for the VM cluster. If false, sparse disk group is not created.


        :return: The is_sparse_diskgroup_enabled of this VmClusterSummary.
        :rtype: bool
        """
        return self._is_sparse_diskgroup_enabled

    @is_sparse_diskgroup_enabled.setter
    def is_sparse_diskgroup_enabled(self, is_sparse_diskgroup_enabled):
        """
        Sets the is_sparse_diskgroup_enabled of this VmClusterSummary.
        If true, sparse disk group is configured for the VM cluster. If false, sparse disk group is not created.


        :param is_sparse_diskgroup_enabled: The is_sparse_diskgroup_enabled of this VmClusterSummary.
        :type: bool
        """
        self._is_sparse_diskgroup_enabled = is_sparse_diskgroup_enabled

    @property
    def vm_cluster_network_id(self):
        """
        Gets the vm_cluster_network_id of this VmClusterSummary.
        The `OCID`__ of the VM cluster network.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The vm_cluster_network_id of this VmClusterSummary.
        :rtype: str
        """
        return self._vm_cluster_network_id

    @vm_cluster_network_id.setter
    def vm_cluster_network_id(self, vm_cluster_network_id):
        """
        Sets the vm_cluster_network_id of this VmClusterSummary.
        The `OCID`__ of the VM cluster network.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param vm_cluster_network_id: The vm_cluster_network_id of this VmClusterSummary.
        :type: str
        """
        self._vm_cluster_network_id = vm_cluster_network_id

    @property
    def cpus_enabled(self):
        """
        Gets the cpus_enabled of this VmClusterSummary.
        The number of enabled CPU cores.


        :return: The cpus_enabled of this VmClusterSummary.
        :rtype: int
        """
        return self._cpus_enabled

    @cpus_enabled.setter
    def cpus_enabled(self, cpus_enabled):
        """
        Sets the cpus_enabled of this VmClusterSummary.
        The number of enabled CPU cores.


        :param cpus_enabled: The cpus_enabled of this VmClusterSummary.
        :type: int
        """
        self._cpus_enabled = cpus_enabled

    @property
    def ocpus_enabled(self):
        """
        Gets the ocpus_enabled of this VmClusterSummary.
        The number of enabled OCPU cores.


        :return: The ocpus_enabled of this VmClusterSummary.
        :rtype: float
        """
        return self._ocpus_enabled

    @ocpus_enabled.setter
    def ocpus_enabled(self, ocpus_enabled):
        """
        Sets the ocpus_enabled of this VmClusterSummary.
        The number of enabled OCPU cores.


        :param ocpus_enabled: The ocpus_enabled of this VmClusterSummary.
        :type: float
        """
        self._ocpus_enabled = ocpus_enabled

    @property
    def memory_size_in_gbs(self):
        """
        Gets the memory_size_in_gbs of this VmClusterSummary.
        The memory allocated in GBs.


        :return: The memory_size_in_gbs of this VmClusterSummary.
        :rtype: int
        """
        return self._memory_size_in_gbs

    @memory_size_in_gbs.setter
    def memory_size_in_gbs(self, memory_size_in_gbs):
        """
        Sets the memory_size_in_gbs of this VmClusterSummary.
        The memory allocated in GBs.


        :param memory_size_in_gbs: The memory_size_in_gbs of this VmClusterSummary.
        :type: int
        """
        self._memory_size_in_gbs = memory_size_in_gbs

    @property
    def db_node_storage_size_in_gbs(self):
        """
        Gets the db_node_storage_size_in_gbs of this VmClusterSummary.
        The local node storage allocated in GBs.


        :return: The db_node_storage_size_in_gbs of this VmClusterSummary.
        :rtype: int
        """
        return self._db_node_storage_size_in_gbs

    @db_node_storage_size_in_gbs.setter
    def db_node_storage_size_in_gbs(self, db_node_storage_size_in_gbs):
        """
        Sets the db_node_storage_size_in_gbs of this VmClusterSummary.
        The local node storage allocated in GBs.


        :param db_node_storage_size_in_gbs: The db_node_storage_size_in_gbs of this VmClusterSummary.
        :type: int
        """
        self._db_node_storage_size_in_gbs = db_node_storage_size_in_gbs

    @property
    def data_storage_size_in_tbs(self):
        """
        Gets the data_storage_size_in_tbs of this VmClusterSummary.
        Size, in terabytes, of the DATA disk group.


        :return: The data_storage_size_in_tbs of this VmClusterSummary.
        :rtype: float
        """
        return self._data_storage_size_in_tbs

    @data_storage_size_in_tbs.setter
    def data_storage_size_in_tbs(self, data_storage_size_in_tbs):
        """
        Sets the data_storage_size_in_tbs of this VmClusterSummary.
        Size, in terabytes, of the DATA disk group.


        :param data_storage_size_in_tbs: The data_storage_size_in_tbs of this VmClusterSummary.
        :type: float
        """
        self._data_storage_size_in_tbs = data_storage_size_in_tbs

    @property
    def data_storage_size_in_gbs(self):
        """
        Gets the data_storage_size_in_gbs of this VmClusterSummary.
        Size of the DATA disk group in GBs.


        :return: The data_storage_size_in_gbs of this VmClusterSummary.
        :rtype: float
        """
        return self._data_storage_size_in_gbs

    @data_storage_size_in_gbs.setter
    def data_storage_size_in_gbs(self, data_storage_size_in_gbs):
        """
        Sets the data_storage_size_in_gbs of this VmClusterSummary.
        Size of the DATA disk group in GBs.


        :param data_storage_size_in_gbs: The data_storage_size_in_gbs of this VmClusterSummary.
        :type: float
        """
        self._data_storage_size_in_gbs = data_storage_size_in_gbs

    @property
    def shape(self):
        """
        Gets the shape of this VmClusterSummary.
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.


        :return: The shape of this VmClusterSummary.
        :rtype: str
        """
        return self._shape

    @shape.setter
    def shape(self, shape):
        """
        Sets the shape of this VmClusterSummary.
        The shape of the Exadata infrastructure. The shape determines the amount of CPU, storage, and memory resources allocated to the instance.


        :param shape: The shape of this VmClusterSummary.
        :type: str
        """
        self._shape = shape

    @property
    def gi_version(self):
        """
        Gets the gi_version of this VmClusterSummary.
        The Oracle Grid Infrastructure software version for the VM cluster.


        :return: The gi_version of this VmClusterSummary.
        :rtype: str
        """
        return self._gi_version

    @gi_version.setter
    def gi_version(self, gi_version):
        """
        Sets the gi_version of this VmClusterSummary.
        The Oracle Grid Infrastructure software version for the VM cluster.


        :param gi_version: The gi_version of this VmClusterSummary.
        :type: str
        """
        self._gi_version = gi_version

    @property
    def system_version(self):
        """
        Gets the system_version of this VmClusterSummary.
        Operating system version of the image.


        :return: The system_version of this VmClusterSummary.
        :rtype: str
        """
        return self._system_version

    @system_version.setter
    def system_version(self, system_version):
        """
        Sets the system_version of this VmClusterSummary.
        Operating system version of the image.


        :param system_version: The system_version of this VmClusterSummary.
        :type: str
        """
        self._system_version = system_version

    @property
    def ssh_public_keys(self):
        """
        Gets the ssh_public_keys of this VmClusterSummary.
        The public key portion of one or more key pairs used for SSH access to the VM cluster.


        :return: The ssh_public_keys of this VmClusterSummary.
        :rtype: list[str]
        """
        return self._ssh_public_keys

    @ssh_public_keys.setter
    def ssh_public_keys(self, ssh_public_keys):
        """
        Sets the ssh_public_keys of this VmClusterSummary.
        The public key portion of one or more key pairs used for SSH access to the VM cluster.


        :param ssh_public_keys: The ssh_public_keys of this VmClusterSummary.
        :type: list[str]
        """
        self._ssh_public_keys = ssh_public_keys

    @property
    def license_model(self):
        """
        Gets the license_model of this VmClusterSummary.
        The Oracle license model that applies to the VM cluster. The default is LICENSE_INCLUDED.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The license_model of this VmClusterSummary.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this VmClusterSummary.
        The Oracle license model that applies to the VM cluster. The default is LICENSE_INCLUDED.


        :param license_model: The license_model of this VmClusterSummary.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            license_model = 'UNKNOWN_ENUM_VALUE'
        self._license_model = license_model

    @property
    def db_servers(self):
        """
        Gets the db_servers of this VmClusterSummary.
        The list of Db server.


        :return: The db_servers of this VmClusterSummary.
        :rtype: list[str]
        """
        return self._db_servers

    @db_servers.setter
    def db_servers(self, db_servers):
        """
        Sets the db_servers of this VmClusterSummary.
        The list of Db server.


        :param db_servers: The db_servers of this VmClusterSummary.
        :type: list[str]
        """
        self._db_servers = db_servers

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this VmClusterSummary.
        The name of the availability domain that the VM cluster is located in.


        :return: The availability_domain of this VmClusterSummary.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this VmClusterSummary.
        The name of the availability domain that the VM cluster is located in.


        :param availability_domain: The availability_domain of this VmClusterSummary.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this VmClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this VmClusterSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this VmClusterSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this VmClusterSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this VmClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this VmClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this VmClusterSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this VmClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this VmClusterSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this VmClusterSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this VmClusterSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this VmClusterSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def data_collection_options(self):
        """
        Gets the data_collection_options of this VmClusterSummary.

        :return: The data_collection_options of this VmClusterSummary.
        :rtype: oci.database.models.DataCollectionOptions
        """
        return self._data_collection_options

    @data_collection_options.setter
    def data_collection_options(self, data_collection_options):
        """
        Sets the data_collection_options of this VmClusterSummary.

        :param data_collection_options: The data_collection_options of this VmClusterSummary.
        :type: oci.database.models.DataCollectionOptions
        """
        self._data_collection_options = data_collection_options

    @property
    def gi_software_image_id(self):
        """
        Gets the gi_software_image_id of this VmClusterSummary.
        The `OCID`__ of a grid infrastructure software image. This is a database software image of the type `GRID_IMAGE`.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The gi_software_image_id of this VmClusterSummary.
        :rtype: str
        """
        return self._gi_software_image_id

    @gi_software_image_id.setter
    def gi_software_image_id(self, gi_software_image_id):
        """
        Sets the gi_software_image_id of this VmClusterSummary.
        The `OCID`__ of a grid infrastructure software image. This is a database software image of the type `GRID_IMAGE`.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param gi_software_image_id: The gi_software_image_id of this VmClusterSummary.
        :type: str
        """
        self._gi_software_image_id = gi_software_image_id

    @property
    def file_system_configuration_details(self):
        """
        Gets the file_system_configuration_details of this VmClusterSummary.
        Details of the file system configuration of the VM cluster.


        :return: The file_system_configuration_details of this VmClusterSummary.
        :rtype: list[oci.database.models.FileSystemConfigurationDetail]
        """
        return self._file_system_configuration_details

    @file_system_configuration_details.setter
    def file_system_configuration_details(self, file_system_configuration_details):
        """
        Sets the file_system_configuration_details of this VmClusterSummary.
        Details of the file system configuration of the VM cluster.


        :param file_system_configuration_details: The file_system_configuration_details of this VmClusterSummary.
        :type: list[oci.database.models.FileSystemConfigurationDetail]
        """
        self._file_system_configuration_details = file_system_configuration_details

    @property
    def vm_cluster_type(self):
        """
        Gets the vm_cluster_type of this VmClusterSummary.
        The vmcluster type for the VM cluster/Cloud VM cluster.

        Allowed values for this property are: "REGULAR", "DEVELOPER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vm_cluster_type of this VmClusterSummary.
        :rtype: str
        """
        return self._vm_cluster_type

    @vm_cluster_type.setter
    def vm_cluster_type(self, vm_cluster_type):
        """
        Sets the vm_cluster_type of this VmClusterSummary.
        The vmcluster type for the VM cluster/Cloud VM cluster.


        :param vm_cluster_type: The vm_cluster_type of this VmClusterSummary.
        :type: str
        """
        allowed_values = ["REGULAR", "DEVELOPER"]
        if not value_allowed_none_or_none_sentinel(vm_cluster_type, allowed_values):
            vm_cluster_type = 'UNKNOWN_ENUM_VALUE'
        self._vm_cluster_type = vm_cluster_type

    @property
    def cloud_automation_update_details(self):
        """
        Gets the cloud_automation_update_details of this VmClusterSummary.

        :return: The cloud_automation_update_details of this VmClusterSummary.
        :rtype: oci.database.models.CloudAutomationUpdateDetails
        """
        return self._cloud_automation_update_details

    @cloud_automation_update_details.setter
    def cloud_automation_update_details(self, cloud_automation_update_details):
        """
        Sets the cloud_automation_update_details of this VmClusterSummary.

        :param cloud_automation_update_details: The cloud_automation_update_details of this VmClusterSummary.
        :type: oci.database.models.CloudAutomationUpdateDetails
        """
        self._cloud_automation_update_details = cloud_automation_update_details

    @property
    def exascale_db_storage_vault_id(self):
        """
        Gets the exascale_db_storage_vault_id of this VmClusterSummary.
        The `OCID`__ of the Exadata Database Storage Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The exascale_db_storage_vault_id of this VmClusterSummary.
        :rtype: str
        """
        return self._exascale_db_storage_vault_id

    @exascale_db_storage_vault_id.setter
    def exascale_db_storage_vault_id(self, exascale_db_storage_vault_id):
        """
        Sets the exascale_db_storage_vault_id of this VmClusterSummary.
        The `OCID`__ of the Exadata Database Storage Vault.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param exascale_db_storage_vault_id: The exascale_db_storage_vault_id of this VmClusterSummary.
        :type: str
        """
        self._exascale_db_storage_vault_id = exascale_db_storage_vault_id

    @property
    def storage_management_type(self):
        """
        Gets the storage_management_type of this VmClusterSummary.
        Specifies whether the type of storage management for the VM cluster is ASM or Exascale.

        Allowed values for this property are: "ASM", "EXASCALE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The storage_management_type of this VmClusterSummary.
        :rtype: str
        """
        return self._storage_management_type

    @storage_management_type.setter
    def storage_management_type(self, storage_management_type):
        """
        Sets the storage_management_type of this VmClusterSummary.
        Specifies whether the type of storage management for the VM cluster is ASM or Exascale.


        :param storage_management_type: The storage_management_type of this VmClusterSummary.
        :type: str
        """
        allowed_values = ["ASM", "EXASCALE"]
        if not value_allowed_none_or_none_sentinel(storage_management_type, allowed_values):
            storage_management_type = 'UNKNOWN_ENUM_VALUE'
        self._storage_management_type = storage_management_type

    @property
    def compute_model(self):
        """
        Gets the compute_model of this VmClusterSummary.
        The compute model of the Autonomous AI Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.

        Allowed values for this property are: "ECPU", "OCPU", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The compute_model of this VmClusterSummary.
        :rtype: str
        """
        return self._compute_model

    @compute_model.setter
    def compute_model(self, compute_model):
        """
        Sets the compute_model of this VmClusterSummary.
        The compute model of the Autonomous AI Database. This is required if using the `computeCount` parameter. If using `cpuCoreCount` then it is an error to specify `computeModel` to a non-null value. ECPU compute model is the recommended model and OCPU compute model is legacy.


        :param compute_model: The compute_model of this VmClusterSummary.
        :type: str
        """
        allowed_values = ["ECPU", "OCPU"]
        if not value_allowed_none_or_none_sentinel(compute_model, allowed_values):
            compute_model = 'UNKNOWN_ENUM_VALUE'
        self._compute_model = compute_model

    @property
    def vm_file_system_storage_type(self):
        """
        Gets the vm_file_system_storage_type of this VmClusterSummary.
        Specifies the type of file system storage and supported values are LOCAL and EXASCALE. - LOCAL if selected then file system storage will be on DB Servers. - EXASCALE if selected then file system storage will be on Exascale Storage Servers. Default Value is LOCAL

        Allowed values for this property are: "LOCAL", "EXASCALE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vm_file_system_storage_type of this VmClusterSummary.
        :rtype: str
        """
        return self._vm_file_system_storage_type

    @vm_file_system_storage_type.setter
    def vm_file_system_storage_type(self, vm_file_system_storage_type):
        """
        Sets the vm_file_system_storage_type of this VmClusterSummary.
        Specifies the type of file system storage and supported values are LOCAL and EXASCALE. - LOCAL if selected then file system storage will be on DB Servers. - EXASCALE if selected then file system storage will be on Exascale Storage Servers. Default Value is LOCAL


        :param vm_file_system_storage_type: The vm_file_system_storage_type of this VmClusterSummary.
        :type: str
        """
        allowed_values = ["LOCAL", "EXASCALE"]
        if not value_allowed_none_or_none_sentinel(vm_file_system_storage_type, allowed_values):
            vm_file_system_storage_type = 'UNKNOWN_ENUM_VALUE'
        self._vm_file_system_storage_type = vm_file_system_storage_type

    @property
    def vm_backup_storage_type(self):
        """
        Gets the vm_backup_storage_type of this VmClusterSummary.
        Specifies the type of VM Backups Storage and supported values are LOCAL and EXASCALE. - LOCAL if selected then VM Backups storage will be on DB Servers. - EXASCALE if selected then VM Backups storage will be on Exascale Storage Servers. Default Value is LOCAL.

        Allowed values for this property are: "LOCAL", "EXASCALE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vm_backup_storage_type of this VmClusterSummary.
        :rtype: str
        """
        return self._vm_backup_storage_type

    @vm_backup_storage_type.setter
    def vm_backup_storage_type(self, vm_backup_storage_type):
        """
        Sets the vm_backup_storage_type of this VmClusterSummary.
        Specifies the type of VM Backups Storage and supported values are LOCAL and EXASCALE. - LOCAL if selected then VM Backups storage will be on DB Servers. - EXASCALE if selected then VM Backups storage will be on Exascale Storage Servers. Default Value is LOCAL.


        :param vm_backup_storage_type: The vm_backup_storage_type of this VmClusterSummary.
        :type: str
        """
        allowed_values = ["LOCAL", "EXASCALE"]
        if not value_allowed_none_or_none_sentinel(vm_backup_storage_type, allowed_values):
            vm_backup_storage_type = 'UNKNOWN_ENUM_VALUE'
        self._vm_backup_storage_type = vm_backup_storage_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
