# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ChangeDatabaseParametersDetails(object):
    """
    The details required to change database parameter values.
    It takes either credentials or databaseCredential. It's recommended to provide databaseCredential
    """

    #: A constant which can be used with the scope property of a ChangeDatabaseParametersDetails.
    #: This constant has a value of "MEMORY"
    SCOPE_MEMORY = "MEMORY"

    #: A constant which can be used with the scope property of a ChangeDatabaseParametersDetails.
    #: This constant has a value of "SPFILE"
    SCOPE_SPFILE = "SPFILE"

    #: A constant which can be used with the scope property of a ChangeDatabaseParametersDetails.
    #: This constant has a value of "BOTH"
    SCOPE_BOTH = "BOTH"

    def __init__(self, **kwargs):
        """
        Initializes a new ChangeDatabaseParametersDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credentials:
            The value to assign to the credentials property of this ChangeDatabaseParametersDetails.
        :type credentials: oci.database_management.models.DatabaseCredentials

        :param database_credential:
            The value to assign to the database_credential property of this ChangeDatabaseParametersDetails.
        :type database_credential: oci.database_management.models.DatabaseCredentialDetails

        :param scope:
            The value to assign to the scope property of this ChangeDatabaseParametersDetails.
            Allowed values for this property are: "MEMORY", "SPFILE", "BOTH"
        :type scope: str

        :param parameters:
            The value to assign to the parameters property of this ChangeDatabaseParametersDetails.
        :type parameters: list[oci.database_management.models.ChangeDatabaseParameterDetails]

        """
        self.swagger_types = {
            'credentials': 'DatabaseCredentials',
            'database_credential': 'DatabaseCredentialDetails',
            'scope': 'str',
            'parameters': 'list[ChangeDatabaseParameterDetails]'
        }
        self.attribute_map = {
            'credentials': 'credentials',
            'database_credential': 'databaseCredential',
            'scope': 'scope',
            'parameters': 'parameters'
        }
        self._credentials = None
        self._database_credential = None
        self._scope = None
        self._parameters = None

    @property
    def credentials(self):
        """
        Gets the credentials of this ChangeDatabaseParametersDetails.

        :return: The credentials of this ChangeDatabaseParametersDetails.
        :rtype: oci.database_management.models.DatabaseCredentials
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials):
        """
        Sets the credentials of this ChangeDatabaseParametersDetails.

        :param credentials: The credentials of this ChangeDatabaseParametersDetails.
        :type: oci.database_management.models.DatabaseCredentials
        """
        self._credentials = credentials

    @property
    def database_credential(self):
        """
        Gets the database_credential of this ChangeDatabaseParametersDetails.

        :return: The database_credential of this ChangeDatabaseParametersDetails.
        :rtype: oci.database_management.models.DatabaseCredentialDetails
        """
        return self._database_credential

    @database_credential.setter
    def database_credential(self, database_credential):
        """
        Sets the database_credential of this ChangeDatabaseParametersDetails.

        :param database_credential: The database_credential of this ChangeDatabaseParametersDetails.
        :type: oci.database_management.models.DatabaseCredentialDetails
        """
        self._database_credential = database_credential

    @property
    def scope(self):
        """
        **[Required]** Gets the scope of this ChangeDatabaseParametersDetails.
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and affect it immediately.
        Use `SPFILE` to make the change in the server parameter file. The
        change takes effect when the database is next shut down and started
        up again. Use `BOTH` to make the change in memory and in the server
        parameter file. The change takes effect immediately and persists
        after the database is shut down and started up again.

        Allowed values for this property are: "MEMORY", "SPFILE", "BOTH"


        :return: The scope of this ChangeDatabaseParametersDetails.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """
        Sets the scope of this ChangeDatabaseParametersDetails.
        The clause used to specify when the parameter change takes effect.

        Use `MEMORY` to make the change in memory and affect it immediately.
        Use `SPFILE` to make the change in the server parameter file. The
        change takes effect when the database is next shut down and started
        up again. Use `BOTH` to make the change in memory and in the server
        parameter file. The change takes effect immediately and persists
        after the database is shut down and started up again.


        :param scope: The scope of this ChangeDatabaseParametersDetails.
        :type: str
        """
        allowed_values = ["MEMORY", "SPFILE", "BOTH"]
        if not value_allowed_none_or_none_sentinel(scope, allowed_values):
            raise ValueError(
                f"Invalid value for `scope`, must be None or one of {allowed_values}"
            )
        self._scope = scope

    @property
    def parameters(self):
        """
        **[Required]** Gets the parameters of this ChangeDatabaseParametersDetails.
        A list of database parameters and their values.


        :return: The parameters of this ChangeDatabaseParametersDetails.
        :rtype: list[oci.database_management.models.ChangeDatabaseParameterDetails]
        """
        return self._parameters

    @parameters.setter
    def parameters(self, parameters):
        """
        Sets the parameters of this ChangeDatabaseParametersDetails.
        A list of database parameters and their values.


        :param parameters: The parameters of this ChangeDatabaseParametersDetails.
        :type: list[oci.database_management.models.ChangeDatabaseParameterDetails]
        """
        self._parameters = parameters

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
