# coding: utf-8
# Copyright (c) 2016, 2026, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudDbSystemDiscovery(object):
    """
    The details of a cloud DB system discovery.
    """

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscovery.
    #: This constant has a value of "VM"
    DEPLOYMENT_TYPE_VM = "VM"

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscovery.
    #: This constant has a value of "EXADATA"
    DEPLOYMENT_TYPE_EXADATA = "EXADATA"

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscovery.
    #: This constant has a value of "EXADATA_CC"
    DEPLOYMENT_TYPE_EXADATA_CC = "EXADATA_CC"

    #: A constant which can be used with the deployment_type property of a CloudDbSystemDiscovery.
    #: This constant has a value of "EXADATA_XS"
    DEPLOYMENT_TYPE_EXADATA_XS = "EXADATA_XS"

    #: A constant which can be used with the lifecycle_state property of a CloudDbSystemDiscovery.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a CloudDbSystemDiscovery.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CloudDbSystemDiscovery.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a CloudDbSystemDiscovery.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a CloudDbSystemDiscovery.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a CloudDbSystemDiscovery.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a CloudDbSystemDiscovery.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new CloudDbSystemDiscovery object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this CloudDbSystemDiscovery.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this CloudDbSystemDiscovery.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CloudDbSystemDiscovery.
        :type compartment_id: str

        :param agent_id:
            The value to assign to the agent_id property of this CloudDbSystemDiscovery.
        :type agent_id: str

        :param dbaas_parent_infrastructure_id:
            The value to assign to the dbaas_parent_infrastructure_id property of this CloudDbSystemDiscovery.
        :type dbaas_parent_infrastructure_id: str

        :param deployment_type:
            The value to assign to the deployment_type property of this CloudDbSystemDiscovery.
            Allowed values for this property are: "VM", "EXADATA", "EXADATA_CC", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type deployment_type: str

        :param grid_home:
            The value to assign to the grid_home property of this CloudDbSystemDiscovery.
        :type grid_home: str

        :param discovered_components:
            The value to assign to the discovered_components property of this CloudDbSystemDiscovery.
        :type discovered_components: list[oci.database_management.models.DiscoveredCloudDbSystemComponent]

        :param resource_id:
            The value to assign to the resource_id property of this CloudDbSystemDiscovery.
        :type resource_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this CloudDbSystemDiscovery.
            Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this CloudDbSystemDiscovery.
        :type lifecycle_details: str

        :param time_created:
            The value to assign to the time_created property of this CloudDbSystemDiscovery.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this CloudDbSystemDiscovery.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CloudDbSystemDiscovery.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CloudDbSystemDiscovery.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this CloudDbSystemDiscovery.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'agent_id': 'str',
            'dbaas_parent_infrastructure_id': 'str',
            'deployment_type': 'str',
            'grid_home': 'str',
            'discovered_components': 'list[DiscoveredCloudDbSystemComponent]',
            'resource_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'agent_id': 'agentId',
            'dbaas_parent_infrastructure_id': 'dbaasParentInfrastructureId',
            'deployment_type': 'deploymentType',
            'grid_home': 'gridHome',
            'discovered_components': 'discoveredComponents',
            'resource_id': 'resourceId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._agent_id = None
        self._dbaas_parent_infrastructure_id = None
        self._deployment_type = None
        self._grid_home = None
        self._discovered_components = None
        self._resource_id = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this CloudDbSystemDiscovery.
        The `OCID`__ of the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this CloudDbSystemDiscovery.
        The `OCID`__ of the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this CloudDbSystemDiscovery.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CloudDbSystemDiscovery.
        The user-friendly name for the DB system. The name does not have to be unique.


        :return: The display_name of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CloudDbSystemDiscovery.
        The user-friendly name for the DB system. The name does not have to be unique.


        :param display_name: The display_name of this CloudDbSystemDiscovery.
        :type: str
        """
        self._display_name = display_name

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CloudDbSystemDiscovery.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def agent_id(self):
        """
        **[Required]** Gets the agent_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the management agent
        used for the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The agent_id of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._agent_id

    @agent_id.setter
    def agent_id(self, agent_id):
        """
        Sets the agent_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the management agent
        used for the cloud DB system discovery.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param agent_id: The agent_id of this CloudDbSystemDiscovery.
        :type: str
        """
        self._agent_id = agent_id

    @property
    def dbaas_parent_infrastructure_id(self):
        """
        **[Required]** Gets the dbaas_parent_infrastructure_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the parent cloud DB Infrastructure. For VM Dbsystems ,
        it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The dbaas_parent_infrastructure_id of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._dbaas_parent_infrastructure_id

    @dbaas_parent_infrastructure_id.setter
    def dbaas_parent_infrastructure_id(self, dbaas_parent_infrastructure_id):
        """
        Sets the dbaas_parent_infrastructure_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the parent cloud DB Infrastructure. For VM Dbsystems ,
        it will be the DBSystem Id. For ExaCS and ExaCC,  it will be the cloudVmClusterId and vmClusterId respectively.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param dbaas_parent_infrastructure_id: The dbaas_parent_infrastructure_id of this CloudDbSystemDiscovery.
        :type: str
        """
        self._dbaas_parent_infrastructure_id = dbaas_parent_infrastructure_id

    @property
    def deployment_type(self):
        """
        **[Required]** Gets the deployment_type of this CloudDbSystemDiscovery.
        The deployment type of cloud dbsystem.

        Allowed values for this property are: "VM", "EXADATA", "EXADATA_CC", "EXADATA_XS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The deployment_type of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this CloudDbSystemDiscovery.
        The deployment type of cloud dbsystem.


        :param deployment_type: The deployment_type of this CloudDbSystemDiscovery.
        :type: str
        """
        allowed_values = ["VM", "EXADATA", "EXADATA_CC", "EXADATA_XS"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            deployment_type = 'UNKNOWN_ENUM_VALUE'
        self._deployment_type = deployment_type

    @property
    def grid_home(self):
        """
        Gets the grid_home of this CloudDbSystemDiscovery.
        The directory in which Oracle Grid Infrastructure is installed.


        :return: The grid_home of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._grid_home

    @grid_home.setter
    def grid_home(self, grid_home):
        """
        Sets the grid_home of this CloudDbSystemDiscovery.
        The directory in which Oracle Grid Infrastructure is installed.


        :param grid_home: The grid_home of this CloudDbSystemDiscovery.
        :type: str
        """
        self._grid_home = grid_home

    @property
    def discovered_components(self):
        """
        Gets the discovered_components of this CloudDbSystemDiscovery.
        The list of DB system components that were found in the DB system discovery.


        :return: The discovered_components of this CloudDbSystemDiscovery.
        :rtype: list[oci.database_management.models.DiscoveredCloudDbSystemComponent]
        """
        return self._discovered_components

    @discovered_components.setter
    def discovered_components(self, discovered_components):
        """
        Sets the discovered_components of this CloudDbSystemDiscovery.
        The list of DB system components that were found in the DB system discovery.


        :param discovered_components: The discovered_components of this CloudDbSystemDiscovery.
        :type: list[oci.database_management.models.DiscoveredCloudDbSystemComponent]
        """
        self._discovered_components = discovered_components

    @property
    def resource_id(self):
        """
        Gets the resource_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the existing OCI resource matching the discovered DB system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The resource_id of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this CloudDbSystemDiscovery.
        The `OCID`__ of the existing OCI resource matching the discovered DB system.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param resource_id: The resource_id of this CloudDbSystemDiscovery.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this CloudDbSystemDiscovery.
        The current lifecycle state of the cloud DB system discovery resource.

        Allowed values for this property are: "CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this CloudDbSystemDiscovery.
        The current lifecycle state of the cloud DB system discovery resource.


        :param lifecycle_state: The lifecycle_state of this CloudDbSystemDiscovery.
        :type: str
        """
        allowed_values = ["CREATING", "ACTIVE", "INACTIVE", "UPDATING", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this CloudDbSystemDiscovery.
        Additional information about the current lifecycle state.


        :return: The lifecycle_details of this CloudDbSystemDiscovery.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this CloudDbSystemDiscovery.
        Additional information about the current lifecycle state.


        :param lifecycle_details: The lifecycle_details of this CloudDbSystemDiscovery.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this CloudDbSystemDiscovery.
        The date and time the cloud DB system discovery was created.


        :return: The time_created of this CloudDbSystemDiscovery.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this CloudDbSystemDiscovery.
        The date and time the cloud DB system discovery was created.


        :param time_created: The time_created of this CloudDbSystemDiscovery.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this CloudDbSystemDiscovery.
        The date and time the cloud DB system discovery was last updated.


        :return: The time_updated of this CloudDbSystemDiscovery.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this CloudDbSystemDiscovery.
        The date and time the cloud DB system discovery was last updated.


        :param time_updated: The time_updated of this CloudDbSystemDiscovery.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CloudDbSystemDiscovery.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this CloudDbSystemDiscovery.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CloudDbSystemDiscovery.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this CloudDbSystemDiscovery.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CloudDbSystemDiscovery.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this CloudDbSystemDiscovery.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CloudDbSystemDiscovery.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this CloudDbSystemDiscovery.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this CloudDbSystemDiscovery.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this CloudDbSystemDiscovery.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this CloudDbSystemDiscovery.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        System tags can be viewed by users, but can only be created by the system.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this CloudDbSystemDiscovery.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
